/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal;

import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.server.api.monitoring.BasicCapability;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactoryListener;
import org.opendaylight.netconf.server.mdsal.CurrentSchemaContext;
import org.opendaylight.netconf.server.mdsal.DOMDataTransactionValidator;
import org.opendaylight.netconf.server.mdsal.MdsalNetconfOperationService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={NetconfOperationServiceFactory.class}, immediate=true, property={"type=mdsal-netconf-connector"})
public final class MdsalNetconfOperationServiceFactory
implements NetconfOperationServiceFactory,
AutoCloseable {
    private static final BasicCapability VALIDATE_CAPABILITY = new BasicCapability("urn:ietf:params:netconf:capability:validate:1.0");
    private final DOMDataBroker dataBroker;
    private final DOMRpcService rpcService;
    private final CurrentSchemaContext currentSchemaContext;
    private final NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener;

    @Activate
    public MdsalNetconfOperationServiceFactory(@Reference DOMSchemaService schemaService, @Reference DOMDataBroker dataBroker, @Reference DOMRpcService rpcService, @Reference(target="(type=mapper-aggregator-registry)") NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.rpcService = Objects.requireNonNull(rpcService);
        this.netconfOperationServiceFactoryListener = Objects.requireNonNull(netconfOperationServiceFactoryListener);
        this.currentSchemaContext = new CurrentSchemaContext(schemaService);
        netconfOperationServiceFactoryListener.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }

    @Override
    @Deactivate
    public void close() {
        this.netconfOperationServiceFactoryListener.onRemoveNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
        this.currentSchemaContext.close();
    }

    public NetconfOperationService createService(SessionIdType sessionId) {
        return new MdsalNetconfOperationService(this.currentSchemaContext, sessionId, this.dataBroker, this.rpcService);
    }

    public Set<Capability> getCapabilities() {
        return this.currentSchemaContext.currentStrategy().capabilities();
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        if (this.dataBroker.extension(DOMDataTransactionValidator.class) != null) {
            listener.onCapabilitiesChanged(Set.of(VALIDATE_CAPABILITY), Set.of());
        }
        return this.currentSchemaContext.registerCapabilityListener(listener);
    }
}

