/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal;

import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.server.mdsal.DOMDataTransactionValidator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionProvider.class);
    private final List<DOMDataTreeReadWriteTransaction> allOpenReadWriteTransactions = new ArrayList<DOMDataTreeReadWriteTransaction>();
    private final DOMDataTransactionValidator transactionValidator;
    private final DOMDataBroker dataBroker;
    private final SessionIdType sessionId;
    private DOMDataTreeReadWriteTransaction candidateTransaction = null;
    private DOMDataTreeReadWriteTransaction runningTransaction = null;

    public TransactionProvider(DOMDataBroker dataBroker, SessionIdType sessionId) {
        this.dataBroker = dataBroker;
        this.sessionId = sessionId;
        this.transactionValidator = (DOMDataTransactionValidator)dataBroker.extension(DOMDataTransactionValidator.class);
    }

    @Override
    public synchronized void close() {
        for (DOMDataTreeReadWriteTransaction rwt : this.allOpenReadWriteTransactions) {
            rwt.cancel();
        }
        this.allOpenReadWriteTransactions.clear();
    }

    public synchronized Optional<DOMDataTreeReadWriteTransaction> getCandidateTransaction() {
        return Optional.ofNullable(this.candidateTransaction);
    }

    public synchronized DOMDataTreeReadWriteTransaction getOrCreateTransaction() {
        if (this.candidateTransaction == null) {
            this.candidateTransaction = this.dataBroker.newReadWriteTransaction();
            this.allOpenReadWriteTransactions.add(this.candidateTransaction);
        }
        return this.candidateTransaction;
    }

    public synchronized void validateTransaction() throws DocumentedException {
        if (this.transactionValidator == null) {
            LOG.error("Validate capability is not supported");
            throw new DocumentedException("Validate capability is not supported", ErrorType.PROTOCOL, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
        }
        if (this.candidateTransaction == null) {
            LOG.debug("Validating empty candidate transaction for session {}", (Object)this.sessionId.getValue());
            return;
        }
        try {
            this.transactionValidator.validate((DOMDataTreeWriteTransaction)this.candidateTransaction).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Candidate transaction validation {} failed on session {}", new Object[]{this.candidateTransaction, this.sessionId.getValue(), e});
            String cause = e.getCause() != null ? " Cause: " + e.getCause().getMessage() : "";
            throw new DocumentedException("Candidate transaction validate failed [sessionId=" + String.valueOf(this.sessionId.getValue()) + "]: " + e.getMessage() + cause, e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
    }

    public synchronized boolean commitTransaction() throws DocumentedException {
        if (this.candidateTransaction == null) {
            LOG.debug("Making commit without open candidate transaction for session {}", (Object)this.sessionId.getValue());
            return true;
        }
        FluentFuture future = this.candidateTransaction.commit();
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Transaction {} failed on", (Object)this.candidateTransaction, (Object)e);
            String cause = e.getCause() != null ? " Cause: " + e.getCause().getMessage() : "";
            throw new DocumentedException("Transaction commit failed on " + e.getMessage() + " " + String.valueOf(this.sessionId.getValue()) + cause, e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
        finally {
            this.allOpenReadWriteTransactions.remove(this.candidateTransaction);
            this.candidateTransaction = null;
        }
        return true;
    }

    public synchronized void abortTransaction() {
        LOG.debug("Aborting current candidateTransaction");
        if (this.candidateTransaction == null) {
            LOG.warn("discard-changes triggerd on an empty transaction for session: {}", (Object)this.sessionId.getValue());
            return;
        }
        this.candidateTransaction.cancel();
        this.allOpenReadWriteTransactions.remove(this.candidateTransaction);
        this.candidateTransaction = null;
    }

    public synchronized DOMDataTreeReadWriteTransaction createRunningTransaction() {
        this.runningTransaction = this.dataBroker.newReadWriteTransaction();
        this.allOpenReadWriteTransactions.add(this.runningTransaction);
        return this.runningTransaction;
    }

    public synchronized void abortRunningTransaction(DOMDataTreeReadWriteTransaction tx) {
        LOG.debug("Aborting current running Transaction");
        if (this.runningTransaction == null) {
            throw new IllegalStateException("No candidateTransaction found for session " + String.valueOf(this.sessionId.getValue()));
        }
        tx.cancel();
        this.allOpenReadWriteTransactions.remove(tx);
    }
}

