/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.monitoring;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class GetSchema
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(GetSchema.class);
    public static final String URN_IETF_PARAMS_XML_NS_YANG_IETF_NETCONF_MONITORING = "urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring";
    private static final String GET_SCHEMA = "get-schema";
    private static final String IDENTIFIER = "identifier";
    private static final String VERSION = "version";
    private final NetconfMonitoringService monitoring;

    public GetSchema(SessionIdType sessionId, NetconfMonitoringService monitoring) {
        super(sessionId);
        this.monitoring = Objects.requireNonNull(monitoring);
    }

    protected String getOperationName() {
        return GET_SCHEMA;
    }

    protected String getOperationNamespace() {
        return URN_IETF_PARAMS_XML_NS_YANG_IETF_NETCONF_MONITORING;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement xml) throws DocumentedException {
        String schema;
        GetSchemaEntry entry = new GetSchemaEntry(xml);
        try {
            schema = this.monitoring.getSchemaForCapability(entry.identifier, Optional.ofNullable(entry.version));
        }
        catch (IllegalStateException e) {
            LOG.warn("Rpc error: {}", (Object)ErrorTag.OPERATION_FAILED, (Object)e);
            throw new DocumentedException(e.getMessage(), (Exception)e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR, Map.of(ErrorTag.OPERATION_FAILED.elementBody(), e.getMessage()));
        }
        Element ret = document.createElementNS(URN_IETF_PARAMS_XML_NS_YANG_IETF_NETCONF_MONITORING, "data");
        ret.appendChild(document.createTextNode(schema));
        LOG.trace("{} operation successful", (Object)GET_SCHEMA);
        return ret;
    }

    private static final class GetSchemaEntry {
        private final @NonNull String identifier;
        private final @Nullable String version;

        GetSchemaEntry(XmlElement getSchemaElement) throws DocumentedException {
            XmlElement identifierElement;
            getSchemaElement.checkName(GetSchema.GET_SCHEMA);
            getSchemaElement.checkNamespace(GetSchema.URN_IETF_PARAMS_XML_NS_YANG_IETF_NETCONF_MONITORING);
            try {
                identifierElement = getSchemaElement.getOnlyChildElementWithSameNamespace(GetSchema.IDENTIFIER);
            }
            catch (DocumentedException e) {
                LOG.trace("Can't get identifier element as only child element with same namespace due to ", (Throwable)e);
                throw DocumentedException.wrap((Exception)((Object)e));
            }
            this.identifier = identifierElement.getTextContent();
            Optional versionElement = getSchemaElement.getOnlyChildElementWithSameNamespaceOptionally(GetSchema.VERSION);
            this.version = versionElement.isPresent() ? ((XmlElement)versionElement.orElseThrow()).getTextContent() : null;
        }
    }
}

