/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.notifications;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.server.api.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationCollector;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChangeBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedByBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.ServerOrUser;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.server.or.user.ServerBuilder;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Empty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public final class CapabilityChangeNotificationProducer
implements DataTreeChangeListener<Capabilities>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CapabilityChangeNotificationProducer.class);
    private final BaseNotificationPublisherRegistration baseNotificationPublisherRegistration;
    private final Registration capabilityChangeListenerRegistration;

    @Activate
    public CapabilityChangeNotificationProducer(@Reference(target="(type=netconf-notification-manager)") NetconfNotificationCollector notifManager, @Reference DataBroker dataBroker) {
        this.baseNotificationPublisherRegistration = notifManager.registerBaseNotificationPublisher();
        this.capabilityChangeListenerRegistration = dataBroker.registerTreeChangeListener(LogicalDatastoreType.OPERATIONAL, (DataObjectReference)DataObjectIdentifier.builder(NetconfState.class).child(Capabilities.class).build(), (DataTreeChangeListener)this);
    }

    @Override
    @Deactivate
    public void close() {
        if (this.baseNotificationPublisherRegistration != null) {
            this.baseNotificationPublisherRegistration.close();
        }
        if (this.capabilityChangeListenerRegistration != null) {
            this.capabilityChangeListenerRegistration.close();
        }
    }

    public void onDataTreeChanged(List<DataTreeModification<Capabilities>> changes) {
        block4: for (DataTreeModification<Capabilities> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            DataObjectModification.ModificationType modificationType = rootNode.modificationType();
            switch (modificationType) {
                case WRITE: {
                    Capabilities dataAfter = (Capabilities)rootNode.dataAfter();
                    Capabilities dataBefore = (Capabilities)rootNode.dataBefore();
                    ImmutableSet before = dataBefore != null ? ImmutableSet.copyOf((Collection)dataBefore.getCapability()) : Set.of();
                    ImmutableSet after = dataAfter != null ? ImmutableSet.copyOf((Collection)dataAfter.getCapability()) : Set.of();
                    Sets.SetView added = Sets.difference((Set)after, (Set)before);
                    Sets.SetView removed = Sets.difference((Set)before, (Set)after);
                    this.publishNotification((Set<Uri>)added, (Set<Uri>)removed);
                    continue block4;
                }
                case DELETE: {
                    Capabilities dataBeforeDelete = (Capabilities)rootNode.dataBefore();
                    if (dataBeforeDelete == null) continue block4;
                    ImmutableSet removed = ImmutableSet.copyOf((Collection)dataBeforeDelete.getCapability());
                    this.publishNotification(Set.of(), (Set<Uri>)removed);
                    continue block4;
                }
            }
            LOG.debug("Received intentionally unhandled type: {}.", (Object)modificationType);
        }
    }

    private void publishNotification(Set<Uri> added, Set<Uri> removed) {
        this.baseNotificationPublisherRegistration.onCapabilityChanged(new NetconfCapabilityChangeBuilder().setChangedBy(new ChangedByBuilder().setServerOrUser((ServerOrUser)new ServerBuilder().setServer(Empty.value()).build()).build()).setAddedCapability(Set.copyOf(added)).setDeletedCapability(Set.copyOf(removed)).setModifiedCapability(Set.of()).build());
    }
}

