/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.notifications;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.messages.NotificationMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationListener;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationRegistry;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.api.operations.SessionAwareNetconfOperation;
import org.opendaylight.netconf.server.mdsal.notifications.NetconfNotificationManager;
import org.opendaylight.netconf.server.spi.SubtreeFilter;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class CreateSubscription
extends AbstractSingletonNetconfOperation
implements SessionAwareNetconfOperation,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSubscription.class);
    static final @NonNull String CREATE_SUBSCRIPTION = "create-subscription";
    private final List<Registration> subscriptions = new ArrayList<Registration>();
    private final NetconfNotificationRegistry notifications;
    private NetconfSession netconfSession;

    CreateSubscription(SessionIdType sessionId, NetconfNotificationRegistry notifications) {
        super(sessionId);
        this.notifications = Objects.requireNonNull(notifications);
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        operationElement.checkName(CREATE_SUBSCRIPTION);
        operationElement.checkNamespace(CreateSubscriptionInput.QNAME.getNamespace().toString());
        Optional filter = operationElement.getOnlyChildElementWithSameNamespaceOptionally("filter");
        Optional startTime = operationElement.getOnlyChildElementWithSameNamespaceOptionally("startTime");
        Preconditions.checkArgument((boolean)startTime.isEmpty(), (Object)"StartTime element not yet supported");
        Optional stopTime = operationElement.getOnlyChildElementWithSameNamespaceOptionally("stopTime");
        Preconditions.checkArgument((boolean)stopTime.isEmpty(), (Object)"StopTime element not yet supported");
        StreamNameType streamNameType = CreateSubscription.parseStreamIfPresent(operationElement);
        Objects.requireNonNull(this.netconfSession);
        if (!this.notifications.isStreamAvailable(streamNameType)) {
            LOG.warn("Registering premature stream {}. No publisher available yet for session {}", (Object)streamNameType, (Object)this.sessionId().getValue());
        }
        this.subscriptions.add(this.notifications.registerNotificationListener(streamNameType, (NetconfNotificationListener)new NotificationSubscription(this.netconfSession, filter)));
        return document.createElement("ok");
    }

    private static StreamNameType parseStreamIfPresent(XmlElement operationElement) throws DocumentedException {
        Optional stream = operationElement.getOnlyChildElementWithSameNamespaceOptionally("stream");
        return stream.isPresent() ? new StreamNameType(((XmlElement)stream.orElseThrow()).getTextContent()) : NetconfNotificationManager.BASE_STREAM_NAME;
    }

    protected String getOperationName() {
        return CREATE_SUBSCRIPTION;
    }

    protected String getOperationNamespace() {
        return CreateSubscriptionInput.QNAME.getNamespace().toString();
    }

    public void setSession(NetconfSession session) {
        this.netconfSession = session;
    }

    @Override
    public void close() {
        this.netconfSession = null;
        this.subscriptions.forEach(Registration::close);
        this.subscriptions.clear();
    }

    private static class NotificationSubscription
    implements NetconfNotificationListener {
        private final NetconfSession currentSession;
        private final XmlElement filter;

        NotificationSubscription(NetconfSession currentSession, Optional<XmlElement> filter) {
            this.currentSession = currentSession;
            this.filter = filter.orElse(null);
        }

        public void onNotification(StreamNameType stream, NotificationMessage notification) {
            if (this.filter == null) {
                this.currentSession.sendMessage((NetconfMessage)notification);
                return;
            }
            try {
                Optional filtered = SubtreeFilter.applySubtreeNotificationFilter((XmlElement)this.filter, (Document)notification.getDocument());
                if (filtered.isPresent()) {
                    this.currentSession.sendMessage((NetconfMessage)NotificationMessage.ofNotificationContent((Document)((Document)filtered.orElseThrow()), (Instant)notification.getEventTime()));
                }
            }
            catch (DocumentedException e) {
                LOG.warn("Failed to process notification {}", (Object)notification, (Object)e);
                this.currentSession.sendMessage((NetconfMessage)notification);
            }
        }
    }
}

