/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.notifications;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.messages.NotificationMessage;
import org.opendaylight.netconf.server.api.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationCollector;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationListener;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationRegistry;
import org.opendaylight.netconf.server.api.notifications.NotificationPublisherRegistration;
import org.opendaylight.netconf.server.api.notifications.YangLibraryPublisherRegistration;
import org.opendaylight.netconf.server.mdsal.notifications.NotificationsTransformUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.StreamsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEnd;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStart;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibraryChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibraryUpdate;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.data.codec.dynamic.BindingDataCodecFactory;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={NetconfNotificationCollector.class, NetconfNotificationRegistry.class}, immediate=true, property={"type=netconf-notification-manager"})
public final class NetconfNotificationManager
implements NetconfNotificationCollector,
NetconfNotificationRegistry,
NetconfNotificationListener,
AutoCloseable {
    public static final StreamNameType BASE_STREAM_NAME = new StreamNameType("NETCONF");
    public static final Stream BASE_NETCONF_STREAM = new StreamBuilder().setName(BASE_STREAM_NAME).withKey(new StreamKey(BASE_STREAM_NAME)).setReplaySupport(Boolean.valueOf(false)).setDescription("Default Event Stream").build();
    private static final Logger LOG = LoggerFactory.getLogger(NetconfNotificationManager.class);
    private final @GuardedBy(value={"this"}) Multimap<StreamNameType, ListenerReg> notificationListeners = HashMultimap.create();
    private final @GuardedBy(value={"this"}) Set<StreamListenerReg> streamListeners = new HashSet<StreamListenerReg>();
    private final @GuardedBy(value={"this"}) Map<StreamNameType, Stream> streamMetadata = new HashMap<StreamNameType, Stream>();
    private final @GuardedBy(value={"this"}) Multiset<StreamNameType> availableStreams = HashMultiset.create();
    private final @GuardedBy(value={"this"}) Set<PublisherReg> notificationPublishers = new HashSet<PublisherReg>();
    private final NotificationsTransformUtil transformUtil;

    @Inject
    @Activate
    public NetconfNotificationManager(@Reference YangParserFactory parserFactory, @Reference BindingRuntimeGenerator generator, @Reference BindingDataCodecFactory codecFactory) throws YangParserException {
        this.transformUtil = new NotificationsTransformUtil(parserFactory, generator, codecFactory);
    }

    @Override
    @PreDestroy
    @Deactivate
    public synchronized void close() {
        List.copyOf(this.notificationListeners.values()).forEach(AbstractRegistration::close);
        this.notificationListeners.clear();
        List.copyOf(this.notificationPublishers).forEach(AbstractRegistration::close);
        this.notificationPublishers.clear();
        this.streamListeners.clear();
    }

    public synchronized void onNotification(StreamNameType stream, NotificationMessage notification) {
        LOG.debug("Notification of type {} detected", (Object)stream);
        if (LOG.isTraceEnabled()) {
            LOG.debug("Notification of type {} detected: {}", (Object)stream, (Object)notification);
        }
        for (ListenerReg listenerReg : this.notificationListeners.get((Object)stream)) {
            ((NetconfNotificationListener)listenerReg.getInstance()).onNotification(stream, notification);
        }
    }

    public synchronized Registration registerNotificationListener(StreamNameType stream, NetconfNotificationListener listener) {
        ListenerReg reg = new ListenerReg(listener, stream);
        LOG.trace("Notification listener registered for stream: {}", (Object)stream);
        this.notificationListeners.put((Object)stream, (Object)reg);
        return reg;
    }

    public synchronized Streams getNotificationPublishers() {
        return new StreamsBuilder().setStream((Map)Maps.uniqueIndex(this.streamMetadata.values(), Stream::key)).build();
    }

    public synchronized boolean isStreamAvailable(StreamNameType streamNameType) {
        return this.availableStreams.contains((Object)streamNameType);
    }

    public synchronized Registration registerStreamListener(NetconfNotificationCollector.NetconfNotificationStreamListener listener) {
        StreamListenerReg reg = new StreamListenerReg(listener);
        this.streamListeners.add(reg);
        for (Stream availableStream : this.streamMetadata.values()) {
            listener.onStreamRegistered(availableStream);
        }
        return reg;
    }

    public synchronized NotificationPublisherRegistration registerNotificationPublisher(Stream stream) {
        Stream prev;
        StreamNameType streamName = Objects.requireNonNull(stream).getName();
        PublisherReg reg = new PublisherReg(this, streamName);
        LOG.debug("Notification publisher registered for stream: {}", (Object)streamName);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Notification publisher registered for stream: {}", (Object)stream);
        }
        if ((prev = this.streamMetadata.putIfAbsent(streamName, stream)) != null) {
            LOG.warn("Notification stream {} already registered as: {}. Will be reused", (Object)streamName, (Object)prev);
        }
        this.availableStreams.add((Object)streamName);
        this.notificationPublishers.add(reg);
        this.notifyStreamAdded(stream);
        return reg;
    }

    private synchronized void unregisterNotificationPublisher(StreamNameType streamName, PublisherReg reg) {
        this.availableStreams.remove((Object)streamName);
        this.notificationPublishers.remove((Object)reg);
        LOG.debug("Notification publisher unregistered for stream: {}", (Object)streamName);
        if (!this.isStreamAvailable(streamName)) {
            LOG.debug("Notification stream: {} became unavailable", (Object)streamName);
            this.streamMetadata.remove(streamName);
            this.notifyStreamRemoved(streamName);
        }
    }

    private synchronized void notifyStreamAdded(Stream stream) {
        for (StreamListenerReg streamListener : this.streamListeners) {
            ((NetconfNotificationCollector.NetconfNotificationStreamListener)streamListener.getInstance()).onStreamRegistered(stream);
        }
    }

    private synchronized void notifyStreamRemoved(StreamNameType stream) {
        for (StreamListenerReg streamListener : this.streamListeners) {
            ((NetconfNotificationCollector.NetconfNotificationStreamListener)streamListener.getInstance()).onStreamUnregistered(stream);
        }
    }

    public BaseNotificationPublisherRegistration registerBaseNotificationPublisher() {
        NotificationPublisherRegistration notificationPublisherRegistration = this.registerNotificationPublisher(BASE_NETCONF_STREAM);
        return new BaseNotificationPublisherReg(this.transformUtil, notificationPublisherRegistration);
    }

    public YangLibraryPublisherRegistration registerYangLibraryPublisher() {
        NotificationPublisherRegistration notificationPublisherRegistration = this.registerNotificationPublisher(BASE_NETCONF_STREAM);
        return new YangLibraryPublisherReg(this.transformUtil, notificationPublisherRegistration);
    }

    private final class ListenerReg
    extends AbstractObjectRegistration<NetconfNotificationListener> {
        private final StreamNameType stream;

        ListenerReg(@NonNull NetconfNotificationListener instance, StreamNameType stream) {
            super((Object)instance);
            this.stream = Objects.requireNonNull(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeRegistration() {
            NetconfNotificationManager netconfNotificationManager = NetconfNotificationManager.this;
            synchronized (netconfNotificationManager) {
                LOG.trace("Notification listener unregistered for stream: {}", (Object)this.stream);
                NetconfNotificationManager.this.notificationListeners.remove((Object)this.stream, (Object)this);
            }
        }
    }

    private final class StreamListenerReg
    extends AbstractObjectRegistration<NetconfNotificationCollector.NetconfNotificationStreamListener> {
        StreamListenerReg(NetconfNotificationCollector.NetconfNotificationStreamListener instance) {
            super((Object)instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeRegistration() {
            NetconfNotificationManager netconfNotificationManager = NetconfNotificationManager.this;
            synchronized (netconfNotificationManager) {
                NetconfNotificationManager.this.streamListeners.remove((Object)this);
            }
        }
    }

    private static final class PublisherReg
    extends AbstractRegistration
    implements NotificationPublisherRegistration {
        private final StreamNameType registeredStream;
        private NetconfNotificationManager manager;

        PublisherReg(NetconfNotificationManager manager, StreamNameType registeredStream) {
            this.manager = Objects.requireNonNull(manager);
            this.registeredStream = Objects.requireNonNull(registeredStream);
        }

        public void onNotification(StreamNameType stream, NotificationMessage notification) {
            Preconditions.checkArgument((boolean)stream.equals((Object)this.registeredStream), (String)"Registered on %s, cannot publish to %s", (Object)this.registeredStream, (Object)stream);
            Preconditions.checkState((boolean)this.notClosed(), (Object)"Already closed");
            this.manager.onNotification(stream, notification);
        }

        protected void removeRegistration() {
            this.manager.unregisterNotificationPublisher(this.registeredStream, this);
            this.manager = null;
        }
    }

    private static class BaseNotificationPublisherReg
    extends AbstractTransformedRegistration
    implements BaseNotificationPublisherRegistration {
        private static final SchemaNodeIdentifier.Absolute CAPABILITY_CHANGE_SCHEMA_PATH = SchemaNodeIdentifier.Absolute.of((QName)NetconfCapabilityChange.QNAME);
        private static final SchemaNodeIdentifier.Absolute SESSION_START_PATH = SchemaNodeIdentifier.Absolute.of((QName)NetconfSessionStart.QNAME);
        private static final SchemaNodeIdentifier.Absolute SESSION_END_PATH = SchemaNodeIdentifier.Absolute.of((QName)NetconfSessionEnd.QNAME);

        BaseNotificationPublisherReg(NotificationsTransformUtil transformUtil, NotificationPublisherRegistration delegate) {
            super(transformUtil, delegate);
        }

        public void onCapabilityChanged(NetconfCapabilityChange capabilityChange) {
            this.publishNotification((Notification<?>)capabilityChange, CAPABILITY_CHANGE_SCHEMA_PATH);
        }

        public void onSessionStarted(NetconfSessionStart start) {
            this.publishNotification((Notification<?>)start, SESSION_START_PATH);
        }

        public void onSessionEnded(NetconfSessionEnd end) {
            this.publishNotification((Notification<?>)end, SESSION_END_PATH);
        }
    }

    private static class YangLibraryPublisherReg
    extends AbstractTransformedRegistration
    implements YangLibraryPublisherRegistration {
        private static final SchemaNodeIdentifier.Absolute YANG_LIBRARY_CHANGE_PATH = SchemaNodeIdentifier.Absolute.of((QName)YangLibraryChange.QNAME);
        private static final SchemaNodeIdentifier.Absolute YANG_LIBRARY_UPDATE_PATH = SchemaNodeIdentifier.Absolute.of((QName)YangLibraryUpdate.QNAME);

        YangLibraryPublisherReg(NotificationsTransformUtil transformUtil, NotificationPublisherRegistration delegate) {
            super(transformUtil, delegate);
        }

        @Deprecated
        public void onYangLibraryChange(YangLibraryChange yangLibraryChange) {
            this.publishNotification((Notification<?>)yangLibraryChange, YANG_LIBRARY_CHANGE_PATH);
        }

        public void onYangLibraryUpdate(YangLibraryUpdate yangLibraryUpdate) {
            this.publishNotification((Notification<?>)yangLibraryUpdate, YANG_LIBRARY_UPDATE_PATH);
        }
    }

    private static abstract class AbstractTransformedRegistration
    implements Registration {
        private final NotificationPublisherRegistration delegate;
        private final NotificationsTransformUtil transformUtil;

        AbstractTransformedRegistration(NotificationsTransformUtil transformUtil, NotificationPublisherRegistration delegate) {
            this.transformUtil = Objects.requireNonNull(transformUtil);
            this.delegate = Objects.requireNonNull(delegate);
        }

        public final void close() {
            this.delegate.close();
        }

        final void publishNotification(Notification<?> notification, SchemaNodeIdentifier.Absolute path) {
            this.delegate.onNotification(BASE_STREAM_NAME, this.transformUtil.transform(notification, path));
        }
    }
}

