/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.notifications;

import java.util.Objects;
import java.util.Set;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationRegistry;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactoryListener;
import org.opendaylight.netconf.server.mdsal.notifications.NetconfNotificationOperationService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={NetconfOperationServiceFactory.class}, immediate=true, property={"type=mdsal-netconf-notification"})
public final class NetconfNotificationOperationServiceFactory
implements NetconfOperationServiceFactory,
AutoCloseable {
    private final NetconfNotificationRegistry notifManager;
    private final NetconfOperationServiceFactoryListener aggregatorRegistry;

    @Activate
    public NetconfNotificationOperationServiceFactory(@Reference(target="(type=netconf-notification-manager)") NetconfNotificationRegistry notifManager, @Reference(target="(type=mapper-aggregator-registry)") NetconfOperationServiceFactoryListener aggregatorRegistry) {
        this.notifManager = Objects.requireNonNull(notifManager);
        this.aggregatorRegistry = Objects.requireNonNull(aggregatorRegistry);
        this.aggregatorRegistry.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }

    @Override
    @Deactivate
    public void close() {
        this.aggregatorRegistry.onRemoveNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }

    public Set<Capability> getCapabilities() {
        return Set.of();
    }

    public NetconfOperationService createService(SessionIdType sessionId) {
        return new NetconfNotificationOperationService(sessionId, this.notifManager);
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        return () -> {};
    }
}

