/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.notifications;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationCollector;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.StreamNameType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.Stream;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.streams.StreamKey;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public final class NotificationToMdsalWriter
implements NetconfNotificationCollector.NetconfNotificationStreamListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationToMdsalWriter.class);
    private static final DataObjectIdentifier<Streams> STREAMS = DataObjectIdentifier.builder(Netconf.class).child(Streams.class).build();
    private final DataBroker dataBroker;
    private final Registration notificationRegistration;

    @Activate
    public NotificationToMdsalWriter(@Reference(target="(type=netconf-notification-manager)") NetconfNotificationCollector notifManager, @Reference DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.notificationRegistration = notifManager.registerStreamListener((NetconfNotificationCollector.NetconfNotificationStreamListener)this);
    }

    @Override
    @Deactivate
    public void close() {
        this.notificationRegistration.close();
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, DataObjectIdentifier.builder(Netconf.class).build());
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(this){

            public void onSuccess(CommitInfo info) {
                LOG.debug("Streams cleared successfully");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to clear streams", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    public void onStreamRegistered(Stream stream) {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.merge(LogicalDatastoreType.OPERATIONAL, NotificationToMdsalWriter.stream(stream.key()), (DataObject)stream);
        try {
            tx.commit().get();
            LOG.debug("Stream {} registered successfully.", (Object)stream.getName());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Unable to register stream {}.", (Object)stream, (Object)e);
        }
    }

    public void onStreamUnregistered(StreamNameType stream) {
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, NotificationToMdsalWriter.stream(new StreamKey(stream)));
        try {
            tx.commit().get();
            LOG.debug("Stream {} unregistered successfully.", (Object)stream);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Unable to unregister stream {}", (Object)stream, (Object)e);
        }
    }

    private static DataObjectIdentifier.WithKey<Stream, StreamKey> stream(StreamKey key) {
        return STREAMS.toBuilder().child(Stream.class, (Key)key).build();
    }
}

