/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.notifications;

import com.google.common.base.Verify;
import java.io.IOException;
import java.time.Instant;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.messages.NotificationMessage;
import org.opendaylight.netconf.api.xml.XMLSupport;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfConfigChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibraryChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibraryUpdate;
import org.opendaylight.yangtools.binding.EventInstantAware;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.binding.data.codec.dynamic.BindingDataCodecFactory;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.yangtools.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.w3c.dom.Document;

final class NotificationsTransformUtil {
    private final EffectiveModelContext modelContext;
    private final BindingNormalizedNodeSerializer serializer;

    NotificationsTransformUtil(YangParserFactory parserFactory, BindingRuntimeGenerator generator, BindingDataCodecFactory codecFactory) throws YangParserException {
        BindingRuntimeContext ctx = BindingRuntimeHelpers.createRuntimeContext((YangParserFactory)parserFactory, (BindingRuntimeGenerator)generator, (Class[])new Class[]{Netconf.class, NetconfConfigChange.class, YangLibraryChange.class, YangLibraryUpdate.class});
        this.modelContext = ctx.modelContext();
        Verify.verify((boolean)this.modelContext.getOperations().stream().filter(input -> input.getQName().getLocalName().equals("create-subscription")).findFirst().isPresent());
        this.serializer = codecFactory.newBindingDataCodec(ctx).nodeSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull NotificationMessage transform(Notification<?> notification, SchemaNodeIdentifier.Absolute path) {
        Instant instant;
        if (notification instanceof EventInstantAware) {
            EventInstantAware aware = (EventInstantAware)notification;
            instant = aware.eventInstant();
        } else {
            instant = null;
        }
        Instant eventTime = instant;
        ContainerNode containerNode = this.serializer.toNormalizedNodeNotification(notification);
        DOMResult result = new DOMResult(XmlUtil.newDocument());
        try (XMLStreamWriter xmlWriter = XMLSupport.newStreamWriter((Result)result);
             NormalizedNodeWriter writer = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)this.modelContext, (SchemaNodeIdentifier.Absolute)path));){
            writer.write((NormalizedNode)containerNode);
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize " + String.valueOf(notification), e);
        }
        Document node = (Document)result.getNode();
        return eventTime != null ? NotificationMessage.ofNotificationContent((Document)node, (Instant)eventTime) : NotificationMessage.ofNotificationContent((Document)node);
    }
}

