/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.notifications;

import java.util.List;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.server.api.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.server.api.notifications.NetconfNotificationCollector;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdOrZeroType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionEndBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfSessionStartBuilder;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
public final class SessionNotificationProducer
implements DataTreeChangeListener<Session>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SessionNotificationProducer.class);
    private final BaseNotificationPublisherRegistration baseNotificationPublisherRegistration;
    private final Registration sessionListenerRegistration;

    @Activate
    public SessionNotificationProducer(@Reference(target="(type=netconf-notification-manager)") NetconfNotificationCollector notifManager, @Reference DataBroker dataBroker) {
        this.baseNotificationPublisherRegistration = notifManager.registerBaseNotificationPublisher();
        this.sessionListenerRegistration = dataBroker.registerTreeChangeListener(LogicalDatastoreType.OPERATIONAL, DataObjectReference.builder(NetconfState.class).child(Sessions.class).child(Session.class).build(), (DataTreeChangeListener)this);
    }

    @Override
    @Deactivate
    public void close() {
        if (this.baseNotificationPublisherRegistration != null) {
            this.baseNotificationPublisherRegistration.close();
        }
        if (this.sessionListenerRegistration != null) {
            this.sessionListenerRegistration.close();
        }
    }

    public void onDataTreeChanged(List<DataTreeModification<Session>> changes) {
        block4: for (DataTreeModification<Session> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            DataObjectModification.ModificationType modificationType = rootNode.modificationType();
            switch (modificationType) {
                case WRITE: {
                    Session created = (Session)rootNode.dataAfter();
                    if (created == null || rootNode.dataBefore() != null) continue block4;
                    this.publishStartedSession(created);
                    continue block4;
                }
                case DELETE: {
                    Session removed = (Session)rootNode.dataBefore();
                    if (removed == null) continue block4;
                    this.publishEndedSession(removed);
                    continue block4;
                }
            }
            LOG.debug("Received intentionally unhandled type: {}.", (Object)modificationType);
        }
    }

    private void publishStartedSession(Session session) {
        this.baseNotificationPublisherRegistration.onSessionStarted(new NetconfSessionStartBuilder().setSessionId(new SessionIdOrZeroType(session.getSessionId())).setSourceHost(session.getSourceHost().getIpAddress()).setUsername(session.getUsername()).build());
    }

    private void publishEndedSession(Session session) {
        this.baseNotificationPublisherRegistration.onSessionEnded(new NetconfSessionEndBuilder().setSessionId(new SessionIdOrZeroType(session.getSessionId())).setSourceHost(session.getSourceHost().getIpAddress()).setUsername(session.getUsername()).build());
    }
}

