/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.databind.DatabindProvider;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.mdsal.operations.Datastore;
import org.opendaylight.netconf.server.mdsal.operations.FilterContentValidator;
import org.opendaylight.netconf.server.mdsal.operations.Get;
import org.opendaylight.netconf.server.mdsal.operations.GetConfig;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.YangInstanceIdentifierWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract sealed class AbstractGet
extends AbstractSingletonNetconfOperation
permits Get, GetConfig {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private final DatabindProvider databindProvider;
    private final FilterContentValidator validator;

    AbstractGet(SessionIdType sessionId, DatabindProvider databindProvider) {
        super(sessionId);
        this.databindProvider = Objects.requireNonNull(databindProvider);
        this.validator = new FilterContentValidator(databindProvider);
    }

    private Node transformNormalizedNode(Document document, NormalizedNode data, YangInstanceIdentifier dataRoot) {
        DOMResult result = new DOMResult(document.createElement("data"));
        XMLStreamWriter xmlWriter = AbstractGet.getXmlStreamWriter(result);
        EffectiveModelContext modelContext = this.databindProvider.currentDatabind().modelContext();
        NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)modelContext);
        try {
            if (dataRoot.isEmpty()) {
                AbstractGet.writeRoot(nnStreamWriter, data);
            } else {
                AbstractGet.write(nnStreamWriter, modelContext, dataRoot.coerceParent(), data);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result.getNode();
    }

    private static void write(NormalizedNodeStreamWriter nnStreamWriter, EffectiveModelContext currentContext, YangInstanceIdentifier parent, NormalizedNode data) throws IOException {
        try (YangInstanceIdentifierWriter yiidWriter = YangInstanceIdentifierWriter.open((NormalizedNodeStreamWriter)nnStreamWriter, (DataNodeContainer)currentContext, (YangInstanceIdentifier)parent);
             NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter, (boolean)true);){
            nnWriter.write(data);
        }
    }

    private static void writeRoot(NormalizedNodeStreamWriter nnStreamWriter, NormalizedNode data) throws IOException {
        Preconditions.checkArgument((boolean)(data instanceof ContainerNode), (String)"Unexpected root data %s", (Object)data);
        try (NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter, (boolean)true);){
            for (DataContainerChild child : ((ContainerNode)data).body()) {
                nnWriter.write((NormalizedNode)child);
            }
        }
    }

    private static XMLStreamWriter getXmlStreamWriter(DOMResult result) {
        try {
            return XML_OUTPUT_FACTORY.createXMLStreamWriter(result);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    final Element serializeNodeWithParentStructure(Document document, YangInstanceIdentifier dataRoot, NormalizedNode node) {
        return (Element)this.transformNormalizedNode(document, node, dataRoot);
    }

    final Optional<YangInstanceIdentifier> getDataRootFromFilter(XmlElement operationElement) throws DocumentedException {
        Optional optFilterElement = operationElement.getOnlyChildElementOptionally("filter");
        if (optFilterElement.isEmpty()) {
            return Optional.of(YangInstanceIdentifier.of());
        }
        XmlElement filterElement = (XmlElement)optFilterElement.orElseThrow();
        if (filterElement.getChildElements().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getInstanceIdentifierFromFilter(filterElement));
    }

    @VisibleForTesting
    protected final YangInstanceIdentifier getInstanceIdentifierFromFilter(XmlElement filterElement) throws DocumentedException {
        if (filterElement.getChildElements().size() != 1) {
            throw new DocumentedException("Multiple filter roots not supported yet", ErrorType.APPLICATION, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
        }
        XmlElement element = filterElement.getOnlyChildElement();
        return this.validator.validate(element);
    }

    protected static final class GetConfigExecution {
        private final Optional<Datastore> datastore;

        GetConfigExecution(Optional<Datastore> datastore) {
            this.datastore = datastore;
        }

        static GetConfigExecution fromXml(XmlElement xml, String operationName) throws DocumentedException {
            Optional<Datastore> sourceDatastore;
            try {
                GetConfigExecution.validateInputRpc(xml, operationName);
            }
            catch (DocumentedException e) {
                throw new DocumentedException("Incorrect RPC: " + e.getMessage(), (Exception)((Object)e), e.getErrorType(), e.getErrorTag(), e.getErrorSeverity(), e.getErrorInfo());
            }
            try {
                sourceDatastore = GetConfigExecution.parseSource(xml);
            }
            catch (DocumentedException e) {
                throw new DocumentedException("Get-config source attribute error: " + e.getMessage(), (Exception)((Object)e), e.getErrorType(), e.getErrorTag(), e.getErrorSeverity(), e.getErrorInfo());
            }
            return new GetConfigExecution(sourceDatastore);
        }

        private static Optional<Datastore> parseSource(XmlElement xml) throws DocumentedException {
            Optional sourceElement = xml.getOnlyChildElementOptionally("source", "urn:ietf:params:xml:ns:netconf:base:1.0");
            return sourceElement.isEmpty() ? Optional.empty() : Optional.of(Datastore.valueOf(((XmlElement)sourceElement.orElseThrow()).getOnlyChildElement().getName()));
        }

        private static void validateInputRpc(XmlElement xml, String operationName) throws DocumentedException {
            xml.checkName(operationName);
            xml.checkNamespace("urn:ietf:params:xml:ns:netconf:base:1.0");
        }

        public Optional<Datastore> getDatastore() {
            return this.datastore;
        }
    }
}

