/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import java.util.Objects;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.mdsal.TransactionProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Commit
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Commit.class);
    private static final String OPERATION_NAME = "commit";
    private final TransactionProvider transactionProvider;

    public Commit(SessionIdType sessionId, TransactionProvider transactionProvider) {
        super(sessionId);
        this.transactionProvider = Objects.requireNonNull(transactionProvider);
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        boolean commitStatus = this.transactionProvider.commitTransaction();
        LOG.trace("Commit completed successfully {}", (Object)commitStatus);
        return document.createElement("ok");
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

