/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.Objects;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public final class DataTreeChange {
    private final NormalizedNode changeRoot;
    private final YangInstanceIdentifier path;
    private final EffectiveOperation action;

    DataTreeChange(NormalizedNode changeRoot, EffectiveOperation action, Deque<YangInstanceIdentifier.PathArgument> path) {
        this.changeRoot = Objects.requireNonNull(changeRoot);
        this.action = Objects.requireNonNull(action);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)path.size());
        path.descendingIterator().forEachRemaining(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.path = YangInstanceIdentifier.of((ImmutableList)builder.build());
    }

    public NormalizedNode getChangeRoot() {
        return this.changeRoot;
    }

    public EffectiveOperation getAction() {
        return this.action;
    }

    public YangInstanceIdentifier getPath() {
        return this.path;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("path", (Object)this.path).add("root", (Object)this.changeRoot).toString();
    }
}

