/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import java.util.HashMap;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.mdsal.TransactionProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscardChanges
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DiscardChanges.class);
    private static final String OPERATION_NAME = "discard-changes";
    private final TransactionProvider transactionProvider;

    public DiscardChanges(SessionIdType sessionId, TransactionProvider transactionProvider) {
        super(sessionId);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        try {
            this.transactionProvider.abortTransaction();
        }
        catch (IllegalStateException e) {
            LOG.warn("Abort failed ", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(ErrorTag.OPERATION_FAILED.elementBody(), "Operation failed. Use 'get-config' or 'edit-config' before triggering discard-changes operation");
            throw new DocumentedException(e.getMessage(), (Exception)e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR, errorInfo);
        }
        return document.createElement("ok");
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

