/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.databind.DatabindContext;
import org.opendaylight.netconf.databind.DatabindProvider;
import org.opendaylight.netconf.server.mdsal.operations.UniversalNamespaceContextImpl;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.data.util.ParserStreamUtils;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class FilterContentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FilterContentValidator.class);
    private final DatabindProvider databindProvider;

    public FilterContentValidator(DatabindProvider databindProvider) {
        this.databindProvider = Objects.requireNonNull(databindProvider);
    }

    public YangInstanceIdentifier validate(XmlElement filterContent) throws DocumentedException {
        XMLNamespace namespace;
        try {
            namespace = XMLNamespace.of((String)filterContent.getNamespace());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong namespace in element + " + filterContent.toString(), e);
        }
        DatabindContext databind = this.databindProvider.currentDatabind();
        EffectiveModelContext modelContext = databind.modelContext();
        Module module = (Module)modelContext.findModules(namespace).iterator().next();
        String name = filterContent.getName();
        for (DataSchemaNode childNode : module.getChildNodes()) {
            QName qName = childNode.getQName();
            if (!qName.getNamespace().equals((Object)namespace) || !qName.getLocalName().equals(name)) continue;
            try {
                FilterTree filterTree = this.validateNode(filterContent, childNode, new FilterTree(childNode.getQName(), Type.OTHER, childNode));
                return this.getFilterDataRoot(filterTree, filterContent, YangInstanceIdentifier.builder());
            }
            catch (ValidationException e) {
                LOG.debug("Filter content isn't valid", (Throwable)e);
                throw new DocumentedException("Validation failed. Cause: " + e.getMessage(), (Exception)e, ErrorType.APPLICATION, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR);
            }
        }
        throw new DocumentedException("Unable to find node with namespace: " + String.valueOf(namespace) + " in schema context: " + String.valueOf(modelContext), ErrorType.APPLICATION, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR);
    }

    private FilterTree validateNode(XmlElement element, DataSchemaNode parentNodeSchema, FilterTree tree) throws ValidationException {
        for (XmlElement childElement : element.getChildElements()) {
            try {
                Deque path = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)parentNodeSchema, (String)childElement.getName(), (XMLNamespace)XMLNamespace.of((String)childElement.getNamespace()));
                if (path.isEmpty()) {
                    throw new ValidationException(element, childElement);
                }
                FilterTree subtree = tree;
                for (DataSchemaNode dataSchemaNode : path) {
                    subtree = subtree.addChild(dataSchemaNode);
                }
                DataSchemaNode childSchema = (DataSchemaNode)path.getLast();
                this.validateNode(childElement, childSchema, subtree);
            }
            catch (IllegalArgumentException | MissingNameSpaceException e) {
                throw new IllegalArgumentException("Wrong namespace in element + " + childElement.toString(), e);
            }
        }
        return tree;
    }

    private YangInstanceIdentifier getFilterDataRoot(FilterTree tree, XmlElement filterContent, YangInstanceIdentifier.InstanceIdentifierBuilder builder) {
        builder.node(tree.getName());
        ArrayList<String> path = new ArrayList<String>();
        FilterTree current = tree;
        while (current.size() == 1) {
            FilterTree child = current.getChildren().iterator().next();
            if (child.getType() == Type.CHOICE_CASE) {
                current = child;
                continue;
            }
            builder.node(child.getName());
            path.add(child.getName().getLocalName());
            if (child.getType() == Type.LIST) {
                this.appendKeyIfPresent(current, child, filterContent, path, builder);
                return builder.build();
            }
            current = child;
        }
        return builder.build();
    }

    private void appendKeyIfPresent(FilterTree parent, FilterTree list, XmlElement filterContent, List<String> pathToList, YangInstanceIdentifier.InstanceIdentifierBuilder builder) {
        Preconditions.checkArgument((boolean)(list.getSchemaNode() instanceof ListSchemaNode));
        ListSchemaNode listSchemaNode = (ListSchemaNode)list.getSchemaNode();
        DataSchemaNode parentSchemaNode = parent.getSchemaNode();
        Map<QName, Object> map = this.getKeyValues(pathToList, filterContent, parentSchemaNode, listSchemaNode);
        if (!map.isEmpty()) {
            builder.nodeWithKey(list.getName(), map);
        }
    }

    private Map<QName, Object> getKeyValues(List<String> path, XmlElement filterContent, DataSchemaNode parentSchemaNode, ListSchemaNode listSchemaNode) {
        XmlElement current = filterContent;
        for (String pathElement : path) {
            List childElements = current.getChildElements(pathElement);
            if (childElements.size() != 1) {
                return Map.of();
            }
            current = (XmlElement)childElements.get(0);
        }
        List keyDef = listSchemaNode.getKeyDefinition();
        HashMap<QName, Object> keys = HashMap.newHashMap(keyDef.size());
        for (QName qname : keyDef) {
            Optional optChildElements = current.getOnlyChildElementOptionally(qname.getLocalName());
            if (optChildElements.isEmpty()) {
                return Map.of();
            }
            ((XmlElement)optChildElements.orElseThrow()).getOnlyTextContentOptionally().ifPresent(keyValue -> {
                LeafSchemaNode listKey = (LeafSchemaNode)listSchemaNode.getDataChildByName(qname);
                if (listKey instanceof IdentityrefTypeDefinition) {
                    keys.put(qname, keyValue);
                } else {
                    TypeDefinition keyType = listKey.getType();
                    if (keyType instanceof IdentityrefTypeDefinition || keyType instanceof LeafrefTypeDefinition || keyType instanceof InstanceIdentifierTypeDefinition) {
                        Document document = filterContent.getDomElement().getOwnerDocument();
                        UniversalNamespaceContextImpl nsContext = new UniversalNamespaceContextImpl(document, false);
                        DatabindContext databind = this.databindProvider.currentDatabind();
                        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)databind.modelContext(), (SchemaNodeIdentifier.Absolute)SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{parentSchemaNode.getQName(), listSchemaNode.getQName(), listKey.getQName()}));
                        keys.put(qname, ((XmlCodec)databind.xmlCodecs().codecFor((TypeAware)listKey, (LeafrefResolver)stack)).parseValue((Object)nsContext, keyValue));
                    } else {
                        keys.put(qname, TypeDefinitionAwareCodec.from((TypeDefinition)keyType).deserialize(keyValue));
                    }
                }
            });
        }
        return keys;
    }

    private static final class FilterTree {
        private final Map<QName, FilterTree> children = new HashMap<QName, FilterTree>();
        private final DataSchemaNode schemaNode;
        private final QName name;
        private final Type type;

        FilterTree(QName name, Type type, DataSchemaNode schemaNode) {
            this.name = name;
            this.type = type;
            this.schemaNode = schemaNode;
        }

        FilterTree addChild(DataSchemaNode data) {
            Type childType = data instanceof CaseSchemaNode ? Type.CHOICE_CASE : (data instanceof ListSchemaNode ? Type.LIST : Type.OTHER);
            QName childName = data.getQName();
            FilterTree childTree = this.children.get(childName);
            if (childTree == null) {
                childTree = new FilterTree(childName, childType, data);
            }
            this.children.put(childName, childTree);
            return childTree;
        }

        Collection<FilterTree> getChildren() {
            return this.children.values();
        }

        QName getName() {
            return this.name;
        }

        Type getType() {
            return this.type;
        }

        DataSchemaNode getSchemaNode() {
            return this.schemaNode;
        }

        int size() {
            return this.children.size();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("size", this.size()).toString();
        }
    }

    private static enum Type {
        LIST,
        CHOICE_CASE,
        OTHER;

    }

    private static class ValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ValidationException(XmlElement parent, XmlElement child) {
            super("Element " + String.valueOf(child) + " can't be child of " + String.valueOf(parent));
        }
    }
}

