/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.databind.DatabindProvider;
import org.opendaylight.netconf.server.mdsal.TransactionProvider;
import org.opendaylight.netconf.server.mdsal.operations.AbstractGet;
import org.opendaylight.netconf.server.mdsal.operations.Datastore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public non-sealed class GetConfig
extends AbstractGet {
    private static final Logger LOG = LoggerFactory.getLogger(GetConfig.class);
    private static final String OPERATION_NAME = "get-config";
    private final TransactionProvider transactionProvider;

    public GetConfig(SessionIdType sessionId, DatabindProvider databindProvider, TransactionProvider transactionProvider) {
        super(sessionId, databindProvider);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        AbstractGet.GetConfigExecution getConfigExecution = null;
        try {
            getConfigExecution = AbstractGet.GetConfigExecution.fromXml(operationElement, OPERATION_NAME);
        }
        catch (DocumentedException e) {
            LOG.warn("Get request processing failed on session: {}", (Object)this.sessionId().getValue(), (Object)e);
            throw e;
        }
        Optional<YangInstanceIdentifier> dataRootOptional = this.getDataRootFromFilter(operationElement);
        if (dataRootOptional.isEmpty()) {
            return document.createElement("data");
        }
        YangInstanceIdentifier dataRoot = dataRootOptional.orElseThrow();
        Datastore datastore = getConfigExecution.getDatastore().orElseThrow(() -> new IllegalStateException("Source element missing from request"));
        DOMDataTreeReadWriteTransaction rwTx = this.getTransaction(datastore);
        try {
            Optional normalizedNodeOptional = (Optional)rwTx.read(LogicalDatastoreType.CONFIGURATION, dataRoot).get();
            if (datastore == Datastore.running) {
                this.transactionProvider.abortRunningTransaction(rwTx);
            }
            if (normalizedNodeOptional.isEmpty()) {
                return document.createElement("data");
            }
            return this.serializeNodeWithParentStructure(document, dataRoot, (NormalizedNode)normalizedNodeOptional.orElseThrow());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Unable to read data: {}", (Object)dataRoot, (Object)e);
            throw new IllegalStateException("Unable to read data " + String.valueOf(dataRoot), e);
        }
    }

    private DOMDataTreeReadWriteTransaction getTransaction(Datastore datastore) throws DocumentedException {
        if (datastore == Datastore.candidate) {
            return this.transactionProvider.getOrCreateTransaction();
        }
        if (datastore == Datastore.running) {
            return this.transactionProvider.createRunningTransaction();
        }
        throw new DocumentedException("Incorrect Datastore: ", ErrorType.PROTOCOL, ErrorTag.BAD_ELEMENT, ErrorSeverity.ERROR);
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

