/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.mdsal.operations.Datastore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Lock
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Lock.class);
    private static final String OPERATION_NAME = "lock";
    private static final String TARGET_KEY = "target";

    public Lock(SessionIdType sessionId) {
        super(sessionId);
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        Datastore targetDatastore = Lock.extractTargetParameter(operationElement);
        if (targetDatastore == Datastore.candidate) {
            LOG.debug("Locking candidate datastore on session: {}", (Object)this.sessionId().getValue());
            return document.createElement("ok");
        }
        throw new DocumentedException("Unable to lock " + String.valueOf((Object)targetDatastore) + " datastore", ErrorType.APPLICATION, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
    }

    static Datastore extractTargetParameter(XmlElement operationElement) throws DocumentedException {
        XmlElement targetElement = operationElement.getOnlyChildElementWithSameNamespace(TARGET_KEY);
        XmlElement targetChildNode = targetElement.getOnlyChildElementWithSameNamespace();
        return Datastore.valueOf(targetChildNode.getName());
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }
}

