/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mdsal.operations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.server.mdsal.operations.ComponentNormalizedNodeStreamWriter;
import org.opendaylight.netconf.server.mdsal.operations.DataTreeChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.EditConfigInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SplittingNormalizedNodeMetadataStreamWriter
implements NormalizedNodeStreamWriter,
NormalizedNodeStreamWriter.MetadataExtension {
    private static final Logger LOG = LoggerFactory.getLogger(SplittingNormalizedNodeMetadataStreamWriter.class);
    private static final QName OPERATION_ATTRIBUTE = QName.create((XMLNamespace)EditConfigInput.QNAME.getNamespace(), (String)"operation");
    private final NormalizationResultHolder result = new NormalizationResultHolder();
    private final List<DataTreeChange> dataTreeChanges = new ArrayList<DataTreeChange>();
    private final Deque<YangInstanceIdentifier.PathArgument> currentPath = new ArrayDeque<YangInstanceIdentifier.PathArgument>();
    private final Deque<EffectiveOperation> actions = new ArrayDeque<EffectiveOperation>();
    private final EffectiveOperation defaultAction;
    private final ComponentNormalizedNodeStreamWriter writer;
    private EffectiveOperation currentAction;
    private int deleteDepth;

    SplittingNormalizedNodeMetadataStreamWriter(EffectiveOperation defaultAction) {
        this.defaultAction = Objects.requireNonNull(defaultAction);
        this.writer = new ComponentNormalizedNodeStreamWriter(this.result);
    }

    List<DataTreeChange> getDataTreeChanges() {
        return this.dataTreeChanges;
    }

    public Collection<? extends NormalizedNodeStreamWriter.Extension> supportedExtensions() {
        return List.of(this);
    }

    public void metadata(ImmutableMap<QName, Object> metadata) throws IOException {
        Object operation = metadata.get((Object)OPERATION_ATTRIBUTE);
        if (operation instanceof String) {
            String str = (String)operation;
            this.currentAction = EffectiveOperation.ofXmlValue((String)str);
        } else if (operation != null) {
            throw new IllegalStateException("Unexpected operation attribute value " + String.valueOf(operation));
        }
        this.writer.metadata(SplittingNormalizedNodeMetadataStreamWriter.filterMeta(metadata));
    }

    private static ImmutableMap<QName, Object> filterMeta(ImmutableMap<QName, Object> metadata) {
        return ImmutableMap.copyOf((Map)Maps.filterKeys(metadata, key -> !XmlParserStream.LEGACY_ATTRIBUTE_NAMESPACE.equals((Object)key.getModule())));
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.writer.startLeafNode(name);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startLeafSet(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startOrderedLeafSet(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.writer.startLeafSetEntryNode(name);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startContainerNode(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startUnkeyedList(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startUnkeyedListItem(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startMapNode(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.writer.startMapEntryNode(identifier, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)identifier);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startOrderedMapNode(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.writer.startChoiceNode(name, childSizeHint);
        this.pushPath((YangInstanceIdentifier.PathArgument)name);
    }

    public boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        return false;
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        boolean ret = this.writer.startAnyxmlNode(name, objectModel);
        if (ret) {
            this.pushPath((YangInstanceIdentifier.PathArgument)name);
        }
        return ret;
    }

    public void endNode() throws IOException {
        EffectiveOperation prevAction = this.actions.peek();
        if (prevAction != null) {
            if (prevAction != this.currentAction && this.deleteDepth == 0) {
                this.dataTreeChanges.add(new DataTreeChange(this.writer.build(), this.currentAction, this.currentPath));
            } else {
                this.writer.endNode();
            }
            this.popPath();
        } else {
            LOG.debug("All done ... writer {}", (Object)this.writer);
            this.writer.endNode();
            this.dataTreeChanges.add(new DataTreeChange(this.result.getResult().data(), this.currentAction, this.currentPath));
        }
    }

    public void domSourceValue(DOMSource value) throws IOException {
        this.writer.domSourceValue(value);
    }

    public void scalarValue(@NonNull Object value) throws IOException {
        this.writer.scalarValue(value);
    }

    public void close() throws IOException {
        Preconditions.checkState((boolean)this.currentPath.isEmpty(), (String)"Cannot close with %s", this.currentPath);
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    private boolean atRemoval() {
        return this.currentAction == EffectiveOperation.DELETE || this.currentAction == EffectiveOperation.REMOVE;
    }

    private void popPath() {
        this.currentPath.pop();
        this.currentAction = this.actions.pop();
        if (this.atRemoval()) {
            Preconditions.checkState((this.deleteDepth > 0 ? 1 : 0) != 0);
            --this.deleteDepth;
        }
    }

    private void pushPath(YangInstanceIdentifier.PathArgument pathArgument) {
        if (this.currentAction != null) {
            if (this.atRemoval()) {
                ++this.deleteDepth;
            }
            this.actions.push(this.currentAction);
        } else {
            this.currentAction = this.defaultAction;
        }
        this.currentPath.push(pathArgument);
    }
}

