/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.api.monitoring;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.server.api.monitoring.BasicCapability;

public final class YangModuleCapability
extends BasicCapability {
    private final String moduleNamespace;
    private final String revision;
    private final String moduleName;
    private final String capabilitySchema;

    public YangModuleCapability(String moduleNamespace, String moduleName, @Nullable String revision, @Nullable String capabilitySchema) {
        super(YangModuleCapability.toCapabilityURI(moduleNamespace, moduleName, revision));
        this.moduleNamespace = Objects.requireNonNull(moduleNamespace);
        this.moduleName = Objects.requireNonNull(moduleName);
        this.revision = revision;
        this.capabilitySchema = capabilitySchema;
    }

    private static String toCapabilityURI(String moduleNamespace, String moduleName, @Nullable String revision) {
        StringBuilder sb = new StringBuilder().append(moduleNamespace).append("?module=").append(moduleName);
        if (revision != null) {
            sb.append("&revision=").append(revision);
        }
        return sb.toString();
    }

    @Override
    public Optional<String> getCapabilitySchema() {
        return Optional.of(this.capabilitySchema);
    }

    @Override
    public Optional<String> getModuleName() {
        return Optional.of(this.moduleName);
    }

    @Override
    public Optional<String> getModuleNamespace() {
        return Optional.of(this.moduleNamespace);
    }

    @Override
    public Optional<String> getRevision() {
        return Optional.ofNullable(this.revision);
    }
}

