/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.api.operations;

import com.google.common.base.Preconditions;
import org.eclipse.jdt.annotation.NonNull;

public record HandlingPriority(int priority) implements Comparable<HandlingPriority>
{
    public static final @NonNull HandlingPriority HANDLE_WITH_DEFAULT_PRIORITY = new HandlingPriority(Integer.MIN_VALUE);
    public static final @NonNull HandlingPriority HANDLE_WITH_MAX_PRIORITY = new HandlingPriority(Integer.MAX_VALUE);

    public HandlingPriority increasePriority(int priorityIncrease) {
        Preconditions.checkArgument((priorityIncrease > 0 ? 1 : 0) != 0, (Object)"Negative increase");
        Preconditions.checkArgument((Long.valueOf(this.priority) + (long)priorityIncrease < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Resulting priority cannot be higher than %s", (int)Integer.MAX_VALUE);
        return new HandlingPriority(this.priority + priorityIncrease);
    }

    @Override
    public int compareTo(HandlingPriority o) {
        return Integer.compare(this.priority, o.priority);
    }
}

