/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mapping.operations;

import java.util.Map;
import java.util.Objects;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultCloseSession
extends AbstractSingletonNetconfOperation
implements DefaultNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCloseSession.class);
    public static final String CLOSE_SESSION = "close-session";
    private final AutoCloseable sessionResources;
    private NetconfServerSession session = null;

    public DefaultCloseSession(SessionIdType sessionId, AutoCloseable sessionResources) {
        super(sessionId);
        this.sessionResources = sessionResources;
    }

    @Override
    protected String getOperationName() {
        return CLOSE_SESSION;
    }

    @Override
    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        try {
            this.sessionResources.close();
            Objects.requireNonNull(this.session, "Session was not set").delayedClose();
            LOG.info("Session {} closing", (Object)this.session.sessionId().getValue());
        }
        catch (Exception e) {
            throw new DocumentedException("Unable to properly close session " + String.valueOf(this.sessionId().getValue()), e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR, Map.of(ErrorSeverity.ERROR.elementBody(), e.getMessage()));
        }
        return document.createElement("ok");
    }

    @Override
    public void setNetconfSession(NetconfServerSession netconfServerSession) {
        this.session = netconfServerSession;
    }
}

