/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mapping.operations;

import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationChainedExecution;
import org.opendaylight.netconf.server.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultStartExi
extends AbstractSingletonNetconfOperation
implements DefaultNetconfOperation {
    public static final String START_EXI = "start-exi";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStartExi.class);
    private NetconfServerSession netconfSession = null;

    public DefaultStartExi(SessionIdType sessionId) {
        super(sessionId);
    }

    @Override
    public Document handle(Document message, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received start-exi message {} ", (Object)XmlUtil.toString((Document)message));
        }
        try {
            this.netconfSession.startExiCommunication(new NetconfMessage(message));
        }
        catch (IllegalArgumentException e) {
            throw new DocumentedException("Failed to parse EXI parameters", (Exception)e, ErrorType.PROTOCOL, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
        return super.handle(message, subsequentOperation);
    }

    @Override
    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) {
        Element getSchemaResult = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "ok");
        LOG.trace("{} operation successful", (Object)START_EXI);
        return getSchemaResult;
    }

    @Override
    protected String getOperationName() {
        return START_EXI;
    }

    @Override
    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:netconf:exi:1.0";
    }

    @Override
    public void setNetconfSession(NetconfServerSession netconfServerSession) {
        this.netconfSession = netconfServerSession;
    }
}

