/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.mapping.operations;

import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.api.operations.AbstractSingletonNetconfOperation;
import org.opendaylight.netconf.server.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultStopExi
extends AbstractSingletonNetconfOperation
implements DefaultNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStopExi.class);
    public static final String STOP_EXI = "stop-exi";
    private NetconfServerSession netconfSession = null;

    public DefaultStopExi(SessionIdType sessionId) {
        super(sessionId);
    }

    @Override
    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) {
        LOG.debug("Received stop-exi message {} ", (Object)XmlUtil.toString((XmlElement)operationElement));
        this.netconfSession.stopExiCommunication();
        Element getSchemaResult = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "ok");
        LOG.trace("{} operation successful", (Object)STOP_EXI);
        return getSchemaResult;
    }

    @Override
    protected String getOperationName() {
        return STOP_EXI;
    }

    @Override
    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:netconf:exi:1.0";
    }

    @Override
    public void setNetconfSession(NetconfServerSession netconfServerSession) {
        this.netconfSession = netconfServerSession;
    }
}

