/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.osgi;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactoryListener;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;

public class AggregatedNetconfOperationServiceFactory
implements NetconfOperationServiceFactory,
NetconfOperationServiceFactoryListener,
AutoCloseable {
    private final Set<NetconfOperationServiceFactory> factories = ConcurrentHashMap.newKeySet();
    private final Multimap<NetconfOperationServiceFactory, Registration> registrations = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Set<CapabilityListener> listeners = ConcurrentHashMap.newKeySet();

    public AggregatedNetconfOperationServiceFactory() {
    }

    public AggregatedNetconfOperationServiceFactory(List<NetconfOperationServiceFactory> mappers) {
        mappers.forEach(this::onAddNetconfOperationServiceFactory);
    }

    @Override
    public final synchronized void onAddNetconfOperationServiceFactory(NetconfOperationServiceFactory service) {
        this.factories.add(service);
        for (CapabilityListener listener : this.listeners) {
            this.registrations.put((Object)service, (Object)service.registerCapabilityListener(listener));
        }
    }

    @Override
    public final synchronized void onRemoveNetconfOperationServiceFactory(NetconfOperationServiceFactory service) {
        this.factories.remove(service);
        this.registrations.removeAll((Object)service).forEach(Registration::close);
    }

    @Override
    public final Set<Capability> getCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        for (NetconfOperationServiceFactory factory : this.factories) {
            capabilities.addAll(factory.getCapabilities());
        }
        return capabilities;
    }

    @Override
    public final synchronized Registration registerCapabilityListener(final CapabilityListener listener) {
        final HashMap<NetconfOperationServiceFactory, Registration> regs = new HashMap<NetconfOperationServiceFactory, Registration>();
        for (NetconfOperationServiceFactory factory : this.factories) {
            regs.put(factory, factory.registerCapabilityListener(listener));
        }
        this.listeners.add(listener);
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                AggregatedNetconfOperationServiceFactory aggregatedNetconfOperationServiceFactory = AggregatedNetconfOperationServiceFactory.this;
                synchronized (aggregatedNetconfOperationServiceFactory) {
                    AggregatedNetconfOperationServiceFactory.this.listeners.remove(listener);
                    regs.values().forEach(Registration::close);
                    for (Map.Entry reg : regs.entrySet()) {
                        AggregatedNetconfOperationServiceFactory.this.registrations.remove(reg.getKey(), reg.getValue());
                    }
                }
            }
        };
    }

    @Override
    public final synchronized NetconfOperationService createService(SessionIdType sessionId) {
        return new AggregatedNetconfOperation(this.factories, sessionId);
    }

    @Override
    public synchronized void close() {
        this.factories.clear();
        this.registrations.values().forEach(Registration::close);
        this.registrations.clear();
        this.listeners.clear();
    }

    private static final class AggregatedNetconfOperation
    implements NetconfOperationService {
        private final ImmutableSet<NetconfOperationService> services;

        AggregatedNetconfOperation(Set<NetconfOperationServiceFactory> factories, SessionIdType sessionId) {
            this.services = (ImmutableSet)factories.stream().map(factory -> factory.createService(sessionId)).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        public Set<NetconfOperation> getNetconfOperations() {
            return (Set)this.services.stream().flatMap(service -> service.getNetconfOperations().stream()).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        public void close() {
            this.services.forEach(NetconfOperationService::close);
        }
    }
}

