/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.osgi;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.netconf.server.api.monitoring.BasicCapability;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.SchemaFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.CapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SchemasBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChangeBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.ChangedByBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.ServerOrUser;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.changed.by.parms.changed.by.server.or.user.ServerBuilder;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Empty;

final class NetconfCapabilityMonitoringService
implements CapabilityListener,
AutoCloseable {
    private static final Schema.Location NETCONF_LOCATION = new Schema.Location(Schema.Location.Enumeration.NETCONF);
    private static final Set<Schema.Location> NETCONF_LOCATIONS = Set.of(NETCONF_LOCATION);
    private static final BasicCapability CANDIDATE_CAPABILITY = new BasicCapability("urn:ietf:params:netconf:capability:candidate:1.0");
    private static final BasicCapability URL_CAPABILITY = new BasicCapability("urn:ietf:params:netconf:capability:url:1.0?scheme=file");
    private static final Function<Capability, Uri> CAPABILITY_TO_URI = input -> new Uri(input.getCapabilityUri());
    private final NetconfOperationServiceFactory netconfOperationProvider;
    private final Map<Uri, Capability> capabilities = new HashMap<Uri, Capability>();
    private final Map<String, Map<String, String>> mappedModulesToRevisionToSchema = new HashMap<String, Map<String, String>>();
    private final Set<NetconfMonitoringService.CapabilitiesListener> listeners = new HashSet<NetconfMonitoringService.CapabilitiesListener>();
    private volatile BaseNotificationPublisherRegistration notificationPublisher;

    NetconfCapabilityMonitoringService(NetconfOperationServiceFactory netconfOperationProvider) {
        this.netconfOperationProvider = netconfOperationProvider;
        netconfOperationProvider.registerCapabilityListener(this);
    }

    synchronized Schemas getSchemas() {
        try {
            return NetconfCapabilityMonitoringService.transformSchemas(this.netconfOperationProvider.getCapabilities());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Exception while closing", e);
        }
    }

    synchronized String getSchemaForModuleRevision(String moduleName, Optional<String> revision) {
        Map<String, String> revisionMapRequest = this.mappedModulesToRevisionToSchema.get(moduleName);
        Preconditions.checkState((revisionMapRequest != null ? 1 : 0) != 0, (String)"Capability for module %s not present, available modules : %s", (Object)moduleName, (Object)Collections2.transform(this.capabilities.values(), CAPABILITY_TO_URI));
        String revToLookup = revision.orElse("");
        String schema = revisionMapRequest.get(revToLookup);
        if (schema != null) {
            return schema;
        }
        Preconditions.checkState((boolean)revision.isEmpty(), (String)"Capability for module %s:%s not present, available revisions for module: %s", (Object)moduleName, (Object)revToLookup, revisionMapRequest.keySet());
        Preconditions.checkState((revisionMapRequest.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 capability for module %s, available revisions : %s", (Object)moduleName, revisionMapRequest.keySet());
        return revisionMapRequest.values().iterator().next();
    }

    private void updateCapabilityToSchemaMap(Set<Capability> added, Set<Capability> removed) {
        for (Capability cap : added) {
            if (!NetconfCapabilityMonitoringService.isValidModuleCapability(cap)) continue;
            this.mappedModulesToRevisionToSchema.computeIfAbsent(cap.getModuleName().orElseThrow(), k -> new HashMap()).put(cap.getRevision().orElse(""), cap.getCapabilitySchema().orElseThrow());
        }
        for (Capability cap : removed) {
            Map<String, String> revisionMap;
            if (!NetconfCapabilityMonitoringService.isValidModuleCapability(cap) || (revisionMap = this.mappedModulesToRevisionToSchema.get(cap.getModuleName().orElseThrow())) == null) continue;
            revisionMap.remove(cap.getRevision().orElseThrow());
            if (!revisionMap.isEmpty()) continue;
            this.mappedModulesToRevisionToSchema.remove(cap.getModuleName().orElseThrow());
        }
    }

    private static boolean isValidModuleCapability(Capability cap) {
        return cap.getModuleName().isPresent() && cap.getCapabilitySchema().isPresent();
    }

    synchronized Capabilities getCapabilities() {
        return new CapabilitiesBuilder().setCapability(Set.copyOf(this.capabilities.keySet())).build();
    }

    synchronized Registration registerListener(final NetconfMonitoringService.CapabilitiesListener listener) {
        this.listeners.add(listener);
        listener.onCapabilitiesChanged(this.getCapabilities());
        listener.onSchemasChanged(this.getSchemas());
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                NetconfCapabilityMonitoringService netconfCapabilityMonitoringService = NetconfCapabilityMonitoringService.this;
                synchronized (netconfCapabilityMonitoringService) {
                    NetconfCapabilityMonitoringService.this.listeners.remove(listener);
                }
            }
        };
    }

    private static Schemas transformSchemas(Set<Capability> caps) {
        HashMap schemas = Maps.newHashMapWithExpectedSize((int)caps.size());
        for (Capability cap : caps) {
            if (!NetconfCapabilityMonitoringService.isValidModuleCapability(cap)) continue;
            SchemaKey key = new SchemaKey((SchemaFormat)Yang.VALUE, cap.getModuleName().orElseThrow(), cap.getRevision().orElse(""));
            schemas.put(key, new SchemaBuilder().withKey(key).setNamespace(new Uri(cap.getModuleNamespace().orElseThrow())).setLocation(NetconfCapabilityMonitoringService.transformLocations(cap.getLocation())).build());
        }
        return new SchemasBuilder().setSchema((Map)schemas).build();
    }

    private static Set<Schema.Location> transformLocations(Collection<String> locations) {
        if (locations.isEmpty()) {
            return NETCONF_LOCATIONS;
        }
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.add((Object)NETCONF_LOCATION);
        for (String location : locations) {
            b.add((Object)new Schema.Location(new Uri(location)));
        }
        return b.build();
    }

    private static Set<Capability> setupCapabilities(Set<Capability> caps) {
        HashSet<Capability> capabilities = new HashSet<Capability>(caps);
        capabilities.add(CANDIDATE_CAPABILITY);
        capabilities.add(URL_CAPABILITY);
        return capabilities;
    }

    @Override
    public synchronized void close() {
        this.listeners.clear();
        this.capabilities.clear();
    }

    @Override
    public synchronized void onCapabilitiesChanged(Set<Capability> added, Set<Capability> removed) {
        this.onCapabilitiesAdded(added);
        this.onCapabilitiesRemoved(removed);
        this.updateCapabilityToSchemaMap(added, removed);
        this.notifyCapabilityChanged(this.getCapabilities());
        if (this.notificationPublisher != null) {
            this.notificationPublisher.onCapabilityChanged(NetconfCapabilityMonitoringService.computeDiff(added, removed));
        }
    }

    private void notifyCapabilityChanged(Capabilities newCapabilities) {
        for (NetconfMonitoringService.CapabilitiesListener listener : this.listeners) {
            listener.onCapabilitiesChanged(newCapabilities);
            listener.onSchemasChanged(this.getSchemas());
        }
    }

    private static NetconfCapabilityChange computeDiff(Set<Capability> added, Set<Capability> removed) {
        return new NetconfCapabilityChangeBuilder().setChangedBy(new ChangedByBuilder().setServerOrUser((ServerOrUser)new ServerBuilder().setServer(Empty.value()).build()).build()).setDeletedCapability(Set.copyOf(Collections2.transform(removed, CAPABILITY_TO_URI))).setAddedCapability(Set.copyOf(Collections2.transform(added, CAPABILITY_TO_URI))).setModifiedCapability(Set.of()).build();
    }

    private void onCapabilitiesAdded(Set<Capability> addedCaps) {
        this.capabilities.putAll((Map<Uri, Capability>)Maps.uniqueIndex(NetconfCapabilityMonitoringService.setupCapabilities(addedCaps), CAPABILITY_TO_URI));
    }

    private void onCapabilitiesRemoved(Set<Capability> removedCaps) {
        for (Capability addedCap : removedCaps) {
            this.capabilities.remove(new Uri(addedCap.getCapabilityUri()));
        }
    }

    void setNotificationPublisher(BaseNotificationPublisherRegistration notificationPublisher) {
        this.notificationPublisher = notificationPublisher;
    }
}

