/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.osgi;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfSession;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.operations.HandlingPriority;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationChainedExecution;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.SessionAwareNetconfOperation;
import org.opendaylight.netconf.server.mapping.operations.DefaultCloseSession;
import org.opendaylight.netconf.server.mapping.operations.DefaultNetconfOperation;
import org.opendaylight.netconf.server.mapping.operations.DefaultStartExi;
import org.opendaylight.netconf.server.mapping.operations.DefaultStopExi;
import org.opendaylight.netconf.server.osgi.NetconfOperationRouter;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NetconfOperationRouterImpl
implements NetconfOperationRouter,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfOperationRouterImpl.class);
    private final NetconfOperationService netconfOperationServiceSnapshot;
    private final Collection<NetconfOperation> allNetconfOperations;

    public NetconfOperationRouterImpl(NetconfOperationService netconfOperationServiceSnapshot, NetconfMonitoringService netconfMonitoringService, SessionIdType sessionId) {
        this.netconfOperationServiceSnapshot = Objects.requireNonNull(netconfOperationServiceSnapshot);
        HashSet<NetconfOperation> ops = new HashSet<NetconfOperation>();
        ops.add(new DefaultCloseSession(sessionId, this));
        ops.add(new DefaultStartExi(sessionId));
        ops.add(new DefaultStopExi(sessionId));
        ops.addAll(netconfOperationServiceSnapshot.getNetconfOperations());
        this.allNetconfOperations = ImmutableSet.copyOf(ops);
    }

    @Override
    public Document onNetconfMessage(Document message, NetconfServerSession session) throws DocumentedException {
        NetconfOperationExecution netconfOperationExecution;
        Objects.requireNonNull(this.allNetconfOperations, "Operation router was not initialized properly");
        try {
            netconfOperationExecution = this.getNetconfOperationWithHighestPriority(message, session);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            String messageAsString = XmlUtil.toString((Document)message);
            LOG.warn("Unable to handle rpc {} on session {}", new Object[]{messageAsString, session, e});
            ErrorTag tag = e instanceof IllegalArgumentException ? ErrorTag.OPERATION_NOT_SUPPORTED : ErrorTag.OPERATION_FAILED;
            throw new DocumentedException(String.format("Unable to handle rpc %s on session %s", messageAsString, session), (Exception)e, ErrorType.APPLICATION, tag, ErrorSeverity.ERROR, Map.of(tag.elementBody(), e.getMessage()));
        }
        catch (RuntimeException e) {
            throw NetconfOperationRouterImpl.handleUnexpectedEx("sort", e);
        }
        try {
            return NetconfOperationRouterImpl.executeOperationWithHighestPriority(message, netconfOperationExecution);
        }
        catch (RuntimeException e) {
            throw NetconfOperationRouterImpl.handleUnexpectedEx("execution", e);
        }
    }

    @Override
    public void close() {
        this.netconfOperationServiceSnapshot.close();
    }

    private static DocumentedException handleUnexpectedEx(String op, Exception exception) {
        LOG.error("Unexpected exception during netconf operation {}", (Object)op, (Object)exception);
        return new DocumentedException("Unexpected error", ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR, Map.of(ErrorSeverity.ERROR.elementBody(), exception.toString()));
    }

    private static Document executeOperationWithHighestPriority(Document message, NetconfOperationExecution netconfOperationExecution) throws DocumentedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding netconf message {} to {}", (Object)XmlUtil.toString((Document)message), (Object)netconfOperationExecution.netconfOperation);
        }
        return netconfOperationExecution.execute(message);
    }

    private NetconfOperationExecution getNetconfOperationWithHighestPriority(Document message, NetconfServerSession session) throws DocumentedException {
        TreeMap<HandlingPriority, NetconfOperation> sortedByPriority = this.getSortedNetconfOperationsWithCanHandle(message, session);
        if (sortedByPriority.isEmpty()) {
            throw new IllegalArgumentException(String.format("No %s available to handle message %s", NetconfOperation.class.getName(), XmlUtil.toString((Document)message)));
        }
        return NetconfOperationExecution.createExecutionChain(sortedByPriority, (HandlingPriority)sortedByPriority.lastKey());
    }

    private TreeMap<HandlingPriority, NetconfOperation> getSortedNetconfOperationsWithCanHandle(Document message, NetconfServerSession session) throws DocumentedException {
        TreeMap<HandlingPriority, NetconfOperation> sortedPriority = new TreeMap<HandlingPriority, NetconfOperation>();
        for (NetconfOperation netconfOperation : this.allNetconfOperations) {
            HandlingPriority handlingPriority = netconfOperation.canHandle(message);
            if (handlingPriority == null) continue;
            NetconfOperation existing = sortedPriority.putIfAbsent(handlingPriority, netconfOperation);
            if (existing != null) {
                throw new IllegalStateException("Multiple %s available to handle message %s with priority %s, %s and %s".formatted(NetconfOperation.class.getName(), message, handlingPriority, netconfOperation, existing));
            }
            if (netconfOperation instanceof DefaultNetconfOperation) {
                DefaultNetconfOperation defaultOperation = (DefaultNetconfOperation)((Object)netconfOperation);
                defaultOperation.setNetconfSession(session);
            }
            if (!(netconfOperation instanceof SessionAwareNetconfOperation)) continue;
            SessionAwareNetconfOperation sessionAwareOperation = (SessionAwareNetconfOperation)netconfOperation;
            sessionAwareOperation.setSession((NetconfSession)session);
        }
        return sortedPriority;
    }

    public String toString() {
        return "NetconfOperationRouterImpl{netconfOperationServiceSnapshot=" + String.valueOf(this.netconfOperationServiceSnapshot) + "}";
    }

    private static final class NetconfOperationExecution
    implements NetconfOperationChainedExecution {
        private final NetconfOperation netconfOperation;
        private final NetconfOperationChainedExecution subsequentExecution;

        private NetconfOperationExecution(NetconfOperation netconfOperation, NetconfOperationChainedExecution subsequentExecution) {
            this.netconfOperation = netconfOperation;
            this.subsequentExecution = subsequentExecution;
        }

        @Override
        public Document execute(Document message) throws DocumentedException {
            return this.netconfOperation.handle(message, this.subsequentExecution);
        }

        public static NetconfOperationExecution createExecutionChain(NavigableMap<HandlingPriority, NetconfOperation> sortedByPriority, HandlingPriority handlingPriority) {
            NetconfOperation netconfOperation = (NetconfOperation)sortedByPriority.get(handlingPriority);
            HandlingPriority subsequentHandlingPriority = sortedByPriority.lowerKey(handlingPriority);
            return new NetconfOperationExecution(netconfOperation, subsequentHandlingPriority == null ? null : NetconfOperationExecution.createExecutionChain(sortedByPriority, subsequentHandlingPriority));
        }
    }
}

