/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.NetconfClient;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.NetconfClientKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.ConnectionType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.ConnectionTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.Endpoints;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.EndpointsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.ReconnectStrategy;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.ReconnectStrategyBuilder;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class NetconfClientBuilder {
    private ConnectionType _connectionType;
    private Endpoints _endpoints;
    private String _name;
    private ReconnectStrategy _reconnectStrategy;
    private NetconfClientKey key;
    Map<Class<? extends Augmentation<NetconfClient>>, Augmentation<NetconfClient>> augmentation = Map.of();

    public NetconfClientBuilder() {
    }

    public NetconfClientBuilder(NetconfClient base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfClient>>, Augmentation<NetconfClient>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._connectionType = base.getConnectionType();
        this._endpoints = base.getEndpoints();
        this._reconnectStrategy = base.getReconnectStrategy();
    }

    public NetconfClientKey key() {
        return this.key;
    }

    public ConnectionType getConnectionType() {
        return this._connectionType;
    }

    public Endpoints getEndpoints() {
        return this._endpoints;
    }

    public String getName() {
        return this._name;
    }

    public ReconnectStrategy getReconnectStrategy() {
        return this._reconnectStrategy;
    }

    public <E$$ extends Augmentation<NetconfClient>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NetconfClientBuilder withKey(NetconfClientKey key) {
        this.key = key;
        return this;
    }

    public NetconfClientBuilder setConnectionType(ConnectionType value) {
        this._connectionType = value;
        return this;
    }

    public NetconfClientBuilder setEndpoints(Endpoints value) {
        this._endpoints = value;
        return this;
    }

    public NetconfClientBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public NetconfClientBuilder setReconnectStrategy(ReconnectStrategy value) {
        this._reconnectStrategy = value;
        return this;
    }

    public NetconfClientBuilder addAugmentation(Augmentation<NetconfClient> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfClient>>, Augmentation<NetconfClient>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NetconfClientBuilder removeAugmentation(Class<? extends Augmentation<NetconfClient>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull NetconfClient build() {
        return new NetconfClientImpl(this);
    }

    private static final class NetconfClientImpl
    extends AbstractEntryObject<NetconfClient, NetconfClientKey>
    implements NetconfClient {
        private final ConnectionType _connectionType;
        private final Endpoints _endpoints;
        private final String _name;
        private final ReconnectStrategy _reconnectStrategy;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfClientImpl(NetconfClientBuilder base) {
            super(base.augmentation, (Key)NetconfClientImpl.extractKey(base));
            NetconfClientKey key = (NetconfClientKey)this.key();
            this._name = key.getName();
            this._connectionType = base.getConnectionType();
            this._endpoints = base.getEndpoints();
            this._reconnectStrategy = base.getReconnectStrategy();
        }

        private static @NonNull NetconfClientKey extractKey(NetconfClientBuilder base) {
            NetconfClientKey key = base.key();
            return key != null ? key : new NetconfClientKey(base.getName());
        }

        @Override
        public ConnectionType getConnectionType() {
            return this._connectionType;
        }

        @Override
        public Endpoints getEndpoints() {
            return this._endpoints;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public ReconnectStrategy getReconnectStrategy() {
            return this._reconnectStrategy;
        }

        @Override
        public ConnectionType nonnullConnectionType() {
            return Objects.requireNonNullElse(this.getConnectionType(), ConnectionTypeBuilder.empty());
        }

        @Override
        public Endpoints nonnullEndpoints() {
            return Objects.requireNonNullElse(this.getEndpoints(), EndpointsBuilder.empty());
        }

        @Override
        public ReconnectStrategy nonnullReconnectStrategy() {
            return Objects.requireNonNullElse(this.getReconnectStrategy(), ReconnectStrategyBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NetconfClient.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NetconfClient.bindingEquals(this, obj);
        }

        public String toString() {
            return NetconfClient.bindingToString(this);
        }
    }
}

