/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Map;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.server.SendErrorExceptionUtil;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeserializerExceptionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DeserializerExceptionHandler.class);

    DeserializerExceptionHandler() {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.warn("An exception occurred during message handling", cause);
        String message = cause.getMessage();
        SendErrorExceptionUtil.sendErrorMessage(ctx.channel(), new DocumentedException(message, ErrorType.RPC, ErrorTag.MALFORMED_MESSAGE, ErrorSeverity.ERROR, message != null ? Map.of("cause", message) : Map.of()));
    }
}

