/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.osgi;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.checkerframework.checker.lock.qual.Holding;
import org.opendaylight.netconf.server.api.monitoring.NetconfManagementSession;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.monitoring.SessionEvent;
import org.opendaylight.netconf.server.api.monitoring.SessionListener;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SessionsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yangtools.binding.util.BindingMap;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract sealed class NetconfSessionMonitoringService
implements SessionListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfSessionMonitoringService.class);
    private final Set<NetconfManagementSession> sessions = new HashSet<NetconfManagementSession>();
    private final Set<NetconfManagementSession> changedSessions = new HashSet<NetconfManagementSession>();
    private final Set<NetconfMonitoringService.SessionsListener> listeners = new HashSet<NetconfMonitoringService.SessionsListener>();

    NetconfSessionMonitoringService() {
    }

    synchronized Sessions getSessions() {
        return new SessionsBuilder().setSession(BindingMap.of((Collection)this.sessions.stream().map(NetconfManagementSession::toManagementSession).collect(Collectors.toList()))).build();
    }

    @Override
    public final synchronized void onSessionUp(NetconfManagementSession session) {
        LOG.debug("Session {} up", (Object)session);
        if (!this.sessions.add(session)) {
            throw new IllegalStateException("Session " + String.valueOf(session) + " was already added");
        }
        Session mgmt = session.toManagementSession();
        for (NetconfMonitoringService.SessionsListener listener : this.listeners) {
            listener.onSessionStarted(mgmt);
        }
    }

    @Override
    public final synchronized void onSessionDown(NetconfManagementSession session) {
        LOG.debug("Session {} down", (Object)session);
        if (!this.sessions.remove(session)) {
            throw new IllegalStateException("Session " + String.valueOf(session) + " not present");
        }
        this.changedSessions.remove(session);
        Session mgmt = session.toManagementSession();
        for (NetconfMonitoringService.SessionsListener listener : this.listeners) {
            listener.onSessionEnded(mgmt);
        }
    }

    @Override
    public final synchronized void onSessionEvent(SessionEvent event) {
        this.changedSessions.add(event.getSession());
    }

    final synchronized Registration registerListener(final NetconfMonitoringService.SessionsListener listener) {
        this.listeners.add(listener);
        this.startTask();
        return new AbstractRegistration(){

            protected void removeRegistration() {
                NetconfSessionMonitoringService.this.listeners.remove(listener);
            }
        };
    }

    @Override
    public final synchronized void close() {
        this.stopTask();
        this.listeners.clear();
        this.sessions.clear();
    }

    @Holding(value={"this"})
    abstract void startTask();

    @Holding(value={"this"})
    abstract void stopTask();

    final synchronized void updateSessionStats() {
        if (!this.changedSessions.isEmpty()) {
            ImmutableList updatedSessions = (ImmutableList)this.changedSessions.stream().map(NetconfManagementSession::toManagementSession).collect(ImmutableList.toImmutableList());
            this.changedSessions.clear();
            for (NetconfMonitoringService.SessionsListener listener : this.listeners) {
                listener.onSessionsUpdated((Collection<Session>)updatedSessions);
            }
        }
    }

    static final class WithUpdates
    extends NetconfSessionMonitoringService {
        private final ScheduledExecutorService executor;
        private final long period;
        private final TimeUnit timeUnit;
        private ScheduledFuture<?> task;

        WithUpdates(ScheduledExecutorService executor, long period, TimeUnit timeUnit) {
            this.executor = Objects.requireNonNull(executor);
            this.period = period;
            this.timeUnit = Objects.requireNonNull(timeUnit);
            LOG.info("/netconf-state/sessions will be updated every {} {}.", (Object)period, (Object)timeUnit);
        }

        @Override
        void startTask() {
            if (this.task == null) {
                this.task = this.executor.scheduleAtFixedRate(this::updateSessionStats, this.period, this.period, this.timeUnit);
            }
        }

        @Override
        void stopTask() {
            if (this.task != null) {
                this.task.cancel(false);
                this.task = null;
            }
        }
    }

    static final class WithoutUpdates
    extends NetconfSessionMonitoringService {
        WithoutUpdates() {
            LOG.info("/netconf-state/sessions will not be updated.");
        }

        @Override
        void startTask() {
        }

        @Override
        void stopTask() {
        }
    }
}

