/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.spi;

import com.google.common.primitives.UnsignedInts;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.server.api.monitoring.JavaCommonCounters;
import org.opendaylight.netconf.server.api.monitoring.MutableJavaCommonCounters;
import org.opendaylight.netconf.server.spi.AbstractJavaCommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters;

@NonNullByDefault
public final class MutableCommonCounters
extends AbstractJavaCommonCounters
implements MutableJavaCommonCounters {
    private int inRpcs;
    private int inBadRpcs;
    private int outRpcErrors;
    private int outNotifications;

    private MutableCommonCounters() {
    }

    private MutableCommonCounters(int inRpcs, int inBadRpcs, int outRpcErrors, int outNotifications) {
        this.inRpcs = inRpcs;
        this.inBadRpcs = inBadRpcs;
        this.outRpcErrors = outRpcErrors;
        this.outNotifications = outNotifications;
    }

    MutableCommonCounters(AbstractJavaCommonCounters from) {
        this.inRpcs = from.rawInRpcs();
        this.inBadRpcs = from.rawInBadRpcs();
        this.outRpcErrors = from.rawOutRpcErrors();
        this.outNotifications = from.rawOutNotifications();
    }

    public static MutableCommonCounters of() {
        return new MutableCommonCounters();
    }

    public static MutableCommonCounters copyOf(CommonCounters values) {
        CommonCounters commonCounters = values;
        Objects.requireNonNull(commonCounters);
        CommonCounters commonCounters2 = commonCounters;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractJavaCommonCounters.class, JavaCommonCounters.class}, (Object)commonCounters2, n)) {
            case 0 -> {
                AbstractJavaCommonCounters from = (AbstractJavaCommonCounters)commonCounters2;
                yield new MutableCommonCounters(from);
            }
            case 1 -> {
                JavaCommonCounters from = (JavaCommonCounters)commonCounters2;
                yield new MutableCommonCounters(UnsignedInts.checkedCast((long)from.inRpcs()), UnsignedInts.checkedCast((long)from.inBadRpcs()), UnsignedInts.checkedCast((long)from.outRpcErrors()), UnsignedInts.checkedCast((long)from.outNotifications()));
            }
            default -> new MutableCommonCounters(MutableCommonCounters.unwrap(values.requireInRpcs()), MutableCommonCounters.unwrap(values.requireInBadRpcs()), MutableCommonCounters.unwrap(values.requireOutRpcErrors()), MutableCommonCounters.unwrap(values.requireOutNotifications()));
        };
    }

    @Override
    public void incInRpcs() {
        ++this.inRpcs;
    }

    @Override
    public void incInBadRpcs() {
        ++this.inBadRpcs;
    }

    @Override
    public void incOutRpcErrors() {
        ++this.outRpcErrors;
    }

    @Override
    public void incOutNotifications() {
        ++this.outNotifications;
    }

    @Override
    int rawInRpcs() {
        return this.inRpcs;
    }

    @Override
    int rawInBadRpcs() {
        return this.inBadRpcs;
    }

    @Override
    int rawOutRpcErrors() {
        return this.outRpcErrors;
    }

    @Override
    int rawOutNotifications() {
        return this.outNotifications;
    }
}

