/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.topology.spi;

import com.google.common.util.concurrent.ForwardingBlockingQueue;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@NonNullByDefault
@Component(service={NetconfTopologySchemaAssembler.class}, configurationPid={"org.opendaylight.netconf.topology"})
@Designate(ocd=Configuration.class)
public final class NetconfTopologySchemaAssembler
implements AutoCloseable {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("topology-schema-assembler-%d").setDaemon(true).build();
    private static final RejectedExecutionHandler BLOCKING_REJECTED_EXECUTION_HANDLER = (runnable, executor) -> {
        try {
            executor.getQueue().put(runnable);
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException("Interrupted while waiting on the queue", e);
        }
    };
    private final ThreadPoolExecutor executor;

    public NetconfTopologySchemaAssembler(int minThreads, int maxThreads, long keepAliveTime, TimeUnit unit) {
        this.executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, unit, (BlockingQueue<Runnable>)((Object)new SynchronousBlockingQueue()), THREAD_FACTORY, BLOCKING_REJECTED_EXECUTION_HANDLER);
    }

    @Activate
    public NetconfTopologySchemaAssembler(Configuration config) {
        this(config.assembler$_$min$_$threads(), config.assembler$_$max$_$threads(), config.assembler$_$keep$_$alive$_$millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    @Deactivate
    public void close() {
        this.executor.shutdown();
    }

    Executor executor() {
        return this.executor;
    }

    private static final class SynchronousBlockingQueue
    extends ForwardingBlockingQueue<Runnable> {
        private final LinkedBlockingQueue<Runnable> delegate = new LinkedBlockingQueue();

        private SynchronousBlockingQueue() {
        }

        protected BlockingQueue<Runnable> delegate() {
            return this.delegate;
        }

        public boolean offer(Runnable o) {
            return false;
        }
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(min="0")
        public int assembler$_$min$_$threads() default 1;

        @AttributeDefinition(min="1")
        public int assembler$_$max$_$threads() default 4;

        @AttributeDefinition(min="0")
        public long assembler$_$keep$_$alive$_$millis() default 60000L;
    }
}

