/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.ConnectionParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.DatastoreAccess;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.NetconfSchemaStorage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.NonModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.NonModuleCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.OdlHelloMessageCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.OdlHelloMessageCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.Protocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.ProtocolBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.YangModuleCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.YangModuleCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.netconf.schema.storage.YangLibrary;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.netconf.schema.storage.YangLibraryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.optional.rev221225.NetconfNodeAugmentedOptionalFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.optional.rev221225.netconf.node.augmented.optional.fields.IgnoreMissingSchemaSources;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.optional.rev221225.netconf.node.augmented.optional.fields.IgnoreMissingSchemaSourcesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.CreateDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.RpcCredentials;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class CreateDeviceInputBuilder {
    private Uint16 _actorResponseWaitTime;
    private Decimal64 _backoffJitter;
    private Decimal64 _backoffMultiplier;
    private Uint16 _concurrentRpcLimit;
    private Uint32 _connectionTimeoutMillis;
    private Uint32 _defaultRequestTimeoutMillis;
    private Host _host;
    private IgnoreMissingSchemaSources _ignoreMissingSchemaSources;
    private Uint32 _keepaliveDelay;
    private Boolean _lockDatastore;
    private Uint32 _maxBackoffMillis;
    private Uint32 _maxConnectionAttempts;
    private Uint16 _minBackoffMillis;
    private String _nodeId;
    private NonModuleCapabilities _nonModuleCapabilities;
    private OdlHelloMessageCapabilities _odlHelloMessageCapabilities;
    private PortNumber _port;
    private Protocol _protocol;
    private Boolean _reconnectOnChangedSchema;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.RpcCredentials _rpcCredentials;
    private String _schemaCacheDirectory;
    private Boolean _schemaless;
    private Boolean _tcpOnly;
    private YangLibrary _yangLibrary;
    private YangModuleCapabilities _yangModuleCapabilities;
    Map<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>> augmentation = Map.of();
    private static final Range<Decimal64>[] CHECKBACKOFFJITTERRANGE_RANGES;
    private static final Range<Decimal64>[] CHECKBACKOFFMULTIPLIERRANGE_RANGES;

    public CreateDeviceInputBuilder() {
    }

    public CreateDeviceInputBuilder(RpcCredentials arg) {
        this._rpcCredentials = arg.getRpcCredentials();
    }

    public CreateDeviceInputBuilder(ConnectionParameters arg) {
        this._host = arg.getHost();
        this._port = arg.getPort();
        this._tcpOnly = arg.getTcpOnly();
        this._protocol = arg.getProtocol();
        this._schemaless = arg.getSchemaless();
        this._yangModuleCapabilities = arg.getYangModuleCapabilities();
        this._nonModuleCapabilities = arg.getNonModuleCapabilities();
        this._reconnectOnChangedSchema = arg.getReconnectOnChangedSchema();
        this._connectionTimeoutMillis = arg.getConnectionTimeoutMillis();
        this._defaultRequestTimeoutMillis = arg.getDefaultRequestTimeoutMillis();
        this._maxConnectionAttempts = arg.getMaxConnectionAttempts();
        this._minBackoffMillis = arg.getMinBackoffMillis();
        this._maxBackoffMillis = arg.getMaxBackoffMillis();
        this._backoffMultiplier = arg.getBackoffMultiplier();
        this._backoffJitter = arg.getBackoffJitter();
        this._keepaliveDelay = arg.getKeepaliveDelay();
        this._concurrentRpcLimit = arg.getConcurrentRpcLimit();
        this._actorResponseWaitTime = arg.getActorResponseWaitTime();
        this._odlHelloMessageCapabilities = arg.getOdlHelloMessageCapabilities();
    }

    public CreateDeviceInputBuilder(NetconfSchemaStorage arg) {
        this._schemaCacheDirectory = arg.getSchemaCacheDirectory();
        this._yangLibrary = arg.getYangLibrary();
    }

    public CreateDeviceInputBuilder(DatastoreAccess arg) {
        this._lockDatastore = arg.getLockDatastore();
    }

    public CreateDeviceInputBuilder(NetconfNodeAugmentedOptionalFields arg) {
        this._ignoreMissingSchemaSources = arg.getIgnoreMissingSchemaSources();
    }

    public CreateDeviceInputBuilder(CreateDeviceInput base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>>(aug);
        }
        this._actorResponseWaitTime = base.getActorResponseWaitTime();
        this._backoffJitter = base.getBackoffJitter();
        this._backoffMultiplier = base.getBackoffMultiplier();
        this._concurrentRpcLimit = base.getConcurrentRpcLimit();
        this._connectionTimeoutMillis = base.getConnectionTimeoutMillis();
        this._defaultRequestTimeoutMillis = base.getDefaultRequestTimeoutMillis();
        this._host = base.getHost();
        this._ignoreMissingSchemaSources = base.getIgnoreMissingSchemaSources();
        this._keepaliveDelay = base.getKeepaliveDelay();
        this._lockDatastore = base.getLockDatastore();
        this._maxBackoffMillis = base.getMaxBackoffMillis();
        this._maxConnectionAttempts = base.getMaxConnectionAttempts();
        this._minBackoffMillis = base.getMinBackoffMillis();
        this._nodeId = base.getNodeId();
        this._nonModuleCapabilities = base.getNonModuleCapabilities();
        this._odlHelloMessageCapabilities = base.getOdlHelloMessageCapabilities();
        this._port = base.getPort();
        this._protocol = base.getProtocol();
        this._reconnectOnChangedSchema = base.getReconnectOnChangedSchema();
        this._rpcCredentials = base.getRpcCredentials();
        this._schemaCacheDirectory = base.getSchemaCacheDirectory();
        this._schemaless = base.getSchemaless();
        this._tcpOnly = base.getTcpOnly();
        this._yangLibrary = base.getYangLibrary();
        this._yangModuleCapabilities = base.getYangModuleCapabilities();
    }

    public void fieldsFrom(Grouping arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof RpcCredentials) {
            castArg = (RpcCredentials)arg;
            this._rpcCredentials = castArg.getRpcCredentials();
            isValidArg = true;
        }
        if (arg instanceof NetconfSchemaStorage) {
            castArg = (NetconfSchemaStorage)arg;
            this._schemaCacheDirectory = castArg.getSchemaCacheDirectory();
            this._yangLibrary = castArg.getYangLibrary();
            isValidArg = true;
        }
        if (arg instanceof ConnectionParameters) {
            castArg = (ConnectionParameters)arg;
            this._host = castArg.getHost();
            this._port = castArg.getPort();
            this._tcpOnly = castArg.getTcpOnly();
            this._protocol = castArg.getProtocol();
            this._schemaless = castArg.getSchemaless();
            this._yangModuleCapabilities = castArg.getYangModuleCapabilities();
            this._nonModuleCapabilities = castArg.getNonModuleCapabilities();
            this._reconnectOnChangedSchema = castArg.getReconnectOnChangedSchema();
            this._connectionTimeoutMillis = castArg.getConnectionTimeoutMillis();
            this._defaultRequestTimeoutMillis = castArg.getDefaultRequestTimeoutMillis();
            this._maxConnectionAttempts = castArg.getMaxConnectionAttempts();
            this._minBackoffMillis = castArg.getMinBackoffMillis();
            this._maxBackoffMillis = castArg.getMaxBackoffMillis();
            this._backoffMultiplier = castArg.getBackoffMultiplier();
            this._backoffJitter = castArg.getBackoffJitter();
            this._keepaliveDelay = castArg.getKeepaliveDelay();
            this._concurrentRpcLimit = castArg.getConcurrentRpcLimit();
            this._actorResponseWaitTime = castArg.getActorResponseWaitTime();
            this._odlHelloMessageCapabilities = castArg.getOdlHelloMessageCapabilities();
            isValidArg = true;
        }
        if (arg instanceof DatastoreAccess) {
            castArg = (DatastoreAccess)arg;
            this._lockDatastore = castArg.getLockDatastore();
            isValidArg = true;
        }
        if (arg instanceof NetconfNodeAugmentedOptionalFields) {
            castArg = (NetconfNodeAugmentedOptionalFields)arg;
            this._ignoreMissingSchemaSources = castArg.getIgnoreMissingSchemaSources();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.RpcCredentials, NetconfSchemaStorage, ConnectionParameters, DatastoreAccess, NetconfNodeAugmentedOptionalFields]");
    }

    public Uint16 getActorResponseWaitTime() {
        return this._actorResponseWaitTime;
    }

    public Decimal64 getBackoffJitter() {
        return this._backoffJitter;
    }

    public Decimal64 getBackoffMultiplier() {
        return this._backoffMultiplier;
    }

    public Uint16 getConcurrentRpcLimit() {
        return this._concurrentRpcLimit;
    }

    public Uint32 getConnectionTimeoutMillis() {
        return this._connectionTimeoutMillis;
    }

    public Uint32 getDefaultRequestTimeoutMillis() {
        return this._defaultRequestTimeoutMillis;
    }

    public Host getHost() {
        return this._host;
    }

    public IgnoreMissingSchemaSources getIgnoreMissingSchemaSources() {
        return this._ignoreMissingSchemaSources;
    }

    public Uint32 getKeepaliveDelay() {
        return this._keepaliveDelay;
    }

    public Boolean getLockDatastore() {
        return this._lockDatastore;
    }

    public Uint32 getMaxBackoffMillis() {
        return this._maxBackoffMillis;
    }

    public Uint32 getMaxConnectionAttempts() {
        return this._maxConnectionAttempts;
    }

    public Uint16 getMinBackoffMillis() {
        return this._minBackoffMillis;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public NonModuleCapabilities getNonModuleCapabilities() {
        return this._nonModuleCapabilities;
    }

    public OdlHelloMessageCapabilities getOdlHelloMessageCapabilities() {
        return this._odlHelloMessageCapabilities;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public Boolean getReconnectOnChangedSchema() {
        return this._reconnectOnChangedSchema;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.RpcCredentials getRpcCredentials() {
        return this._rpcCredentials;
    }

    public String getSchemaCacheDirectory() {
        return this._schemaCacheDirectory;
    }

    public Boolean getSchemaless() {
        return this._schemaless;
    }

    public Boolean getTcpOnly() {
        return this._tcpOnly;
    }

    public YangLibrary getYangLibrary() {
        return this._yangLibrary;
    }

    public YangModuleCapabilities getYangModuleCapabilities() {
        return this._yangModuleCapabilities;
    }

    public <E$$ extends Augmentation<CreateDeviceInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkActorResponseWaitTimeRange(int value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..65535]]", (int)value);
    }

    public CreateDeviceInputBuilder setActorResponseWaitTime(Uint16 value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkActorResponseWaitTimeRange(value.intValue());
        }
        this._actorResponseWaitTime = value;
        return this;
    }

    private static void checkBackoffJitterRange(Decimal64 value) {
        for (Range<Decimal64> r : CHECKBACKOFFJITTERRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKBACKOFFJITTERRANGE_RANGES, (Object)value);
    }

    public CreateDeviceInputBuilder setBackoffJitter(Decimal64 value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkBackoffJitterRange(value);
        }
        this._backoffJitter = value;
        return this;
    }

    private static void checkBackoffMultiplierRange(Decimal64 value) {
        for (Range<Decimal64> r : CHECKBACKOFFMULTIPLIERRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKBACKOFFMULTIPLIERRANGE_RANGES, (Object)value);
    }

    public CreateDeviceInputBuilder setBackoffMultiplier(Decimal64 value) {
        if (value != null) {
            CreateDeviceInputBuilder.checkBackoffMultiplierRange(value);
        }
        this._backoffMultiplier = value;
        return this;
    }

    public CreateDeviceInputBuilder setConcurrentRpcLimit(Uint16 value) {
        this._concurrentRpcLimit = value;
        return this;
    }

    public CreateDeviceInputBuilder setConnectionTimeoutMillis(Uint32 value) {
        this._connectionTimeoutMillis = value;
        return this;
    }

    public CreateDeviceInputBuilder setDefaultRequestTimeoutMillis(Uint32 value) {
        this._defaultRequestTimeoutMillis = value;
        return this;
    }

    public CreateDeviceInputBuilder setHost(Host value) {
        this._host = value;
        return this;
    }

    public CreateDeviceInputBuilder setIgnoreMissingSchemaSources(IgnoreMissingSchemaSources value) {
        this._ignoreMissingSchemaSources = value;
        return this;
    }

    public CreateDeviceInputBuilder setKeepaliveDelay(Uint32 value) {
        this._keepaliveDelay = value;
        return this;
    }

    public CreateDeviceInputBuilder setLockDatastore(Boolean value) {
        this._lockDatastore = value;
        return this;
    }

    public CreateDeviceInputBuilder setMaxBackoffMillis(Uint32 value) {
        this._maxBackoffMillis = value;
        return this;
    }

    public CreateDeviceInputBuilder setMaxConnectionAttempts(Uint32 value) {
        this._maxConnectionAttempts = value;
        return this;
    }

    public CreateDeviceInputBuilder setMinBackoffMillis(Uint16 value) {
        this._minBackoffMillis = value;
        return this;
    }

    public CreateDeviceInputBuilder setNodeId(String value) {
        this._nodeId = value;
        return this;
    }

    public CreateDeviceInputBuilder setNonModuleCapabilities(NonModuleCapabilities value) {
        this._nonModuleCapabilities = value;
        return this;
    }

    public CreateDeviceInputBuilder setOdlHelloMessageCapabilities(OdlHelloMessageCapabilities value) {
        this._odlHelloMessageCapabilities = value;
        return this;
    }

    public CreateDeviceInputBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public CreateDeviceInputBuilder setProtocol(Protocol value) {
        this._protocol = value;
        return this;
    }

    public CreateDeviceInputBuilder setReconnectOnChangedSchema(Boolean value) {
        this._reconnectOnChangedSchema = value;
        return this;
    }

    public CreateDeviceInputBuilder setRpcCredentials(org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.RpcCredentials value) {
        this._rpcCredentials = value;
        return this;
    }

    public CreateDeviceInputBuilder setSchemaCacheDirectory(String value) {
        this._schemaCacheDirectory = value;
        return this;
    }

    public CreateDeviceInputBuilder setSchemaless(Boolean value) {
        this._schemaless = value;
        return this;
    }

    public CreateDeviceInputBuilder setTcpOnly(Boolean value) {
        this._tcpOnly = value;
        return this;
    }

    public CreateDeviceInputBuilder setYangLibrary(YangLibrary value) {
        this._yangLibrary = value;
        return this;
    }

    public CreateDeviceInputBuilder setYangModuleCapabilities(YangModuleCapabilities value) {
        this._yangModuleCapabilities = value;
        return this;
    }

    public CreateDeviceInputBuilder addAugmentation(Augmentation<CreateDeviceInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateDeviceInput>>, Augmentation<CreateDeviceInput>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public CreateDeviceInputBuilder removeAugmentation(Class<? extends Augmentation<CreateDeviceInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull CreateDeviceInput build() {
        return new CreateDeviceInputImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)Decimal64.of((int)1, (long)0L), (Comparable)Decimal64.of((int)1, (long)5L));
        CHECKBACKOFFJITTERRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)Decimal64.of((int)1, (long)10L), (Comparable)Decimal64.of((int)1, (long)Long.MAX_VALUE));
        CHECKBACKOFFMULTIPLIERRANGE_RANGES = a;
    }

    private static final class CreateDeviceInputImpl
    extends AbstractAugmentable<CreateDeviceInput>
    implements CreateDeviceInput {
        private final Uint16 _actorResponseWaitTime;
        private final Decimal64 _backoffJitter;
        private final Decimal64 _backoffMultiplier;
        private final Uint16 _concurrentRpcLimit;
        private final Uint32 _connectionTimeoutMillis;
        private final Uint32 _defaultRequestTimeoutMillis;
        private final Host _host;
        private final IgnoreMissingSchemaSources _ignoreMissingSchemaSources;
        private final Uint32 _keepaliveDelay;
        private final Boolean _lockDatastore;
        private final Uint32 _maxBackoffMillis;
        private final Uint32 _maxConnectionAttempts;
        private final Uint16 _minBackoffMillis;
        private final String _nodeId;
        private final NonModuleCapabilities _nonModuleCapabilities;
        private final OdlHelloMessageCapabilities _odlHelloMessageCapabilities;
        private final PortNumber _port;
        private final Protocol _protocol;
        private final Boolean _reconnectOnChangedSchema;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.RpcCredentials _rpcCredentials;
        private final String _schemaCacheDirectory;
        private final Boolean _schemaless;
        private final Boolean _tcpOnly;
        private final YangLibrary _yangLibrary;
        private final YangModuleCapabilities _yangModuleCapabilities;
        private int hash = 0;
        private volatile boolean hashValid = false;

        CreateDeviceInputImpl(CreateDeviceInputBuilder base) {
            super(base.augmentation);
            this._actorResponseWaitTime = base.getActorResponseWaitTime();
            this._backoffJitter = base.getBackoffJitter();
            this._backoffMultiplier = base.getBackoffMultiplier();
            this._concurrentRpcLimit = base.getConcurrentRpcLimit();
            this._connectionTimeoutMillis = base.getConnectionTimeoutMillis();
            this._defaultRequestTimeoutMillis = base.getDefaultRequestTimeoutMillis();
            this._host = base.getHost();
            this._ignoreMissingSchemaSources = base.getIgnoreMissingSchemaSources();
            this._keepaliveDelay = base.getKeepaliveDelay();
            this._lockDatastore = base.getLockDatastore();
            this._maxBackoffMillis = base.getMaxBackoffMillis();
            this._maxConnectionAttempts = base.getMaxConnectionAttempts();
            this._minBackoffMillis = base.getMinBackoffMillis();
            this._nodeId = base.getNodeId();
            this._nonModuleCapabilities = base.getNonModuleCapabilities();
            this._odlHelloMessageCapabilities = base.getOdlHelloMessageCapabilities();
            this._port = base.getPort();
            this._protocol = base.getProtocol();
            this._reconnectOnChangedSchema = base.getReconnectOnChangedSchema();
            this._rpcCredentials = base.getRpcCredentials();
            this._schemaCacheDirectory = base.getSchemaCacheDirectory();
            this._schemaless = base.getSchemaless();
            this._tcpOnly = base.getTcpOnly();
            this._yangLibrary = base.getYangLibrary();
            this._yangModuleCapabilities = base.getYangModuleCapabilities();
        }

        public Uint16 getActorResponseWaitTime() {
            return this._actorResponseWaitTime;
        }

        public Decimal64 getBackoffJitter() {
            return this._backoffJitter;
        }

        public Decimal64 getBackoffMultiplier() {
            return this._backoffMultiplier;
        }

        public Uint16 getConcurrentRpcLimit() {
            return this._concurrentRpcLimit;
        }

        public Uint32 getConnectionTimeoutMillis() {
            return this._connectionTimeoutMillis;
        }

        public Uint32 getDefaultRequestTimeoutMillis() {
            return this._defaultRequestTimeoutMillis;
        }

        public Host getHost() {
            return this._host;
        }

        @Override
        public IgnoreMissingSchemaSources getIgnoreMissingSchemaSources() {
            return this._ignoreMissingSchemaSources;
        }

        public Uint32 getKeepaliveDelay() {
            return this._keepaliveDelay;
        }

        public Boolean getLockDatastore() {
            return this._lockDatastore;
        }

        public Uint32 getMaxBackoffMillis() {
            return this._maxBackoffMillis;
        }

        public Uint32 getMaxConnectionAttempts() {
            return this._maxConnectionAttempts;
        }

        public Uint16 getMinBackoffMillis() {
            return this._minBackoffMillis;
        }

        @Override
        public String getNodeId() {
            return this._nodeId;
        }

        public NonModuleCapabilities getNonModuleCapabilities() {
            return this._nonModuleCapabilities;
        }

        public OdlHelloMessageCapabilities getOdlHelloMessageCapabilities() {
            return this._odlHelloMessageCapabilities;
        }

        public PortNumber getPort() {
            return this._port;
        }

        public Protocol getProtocol() {
            return this._protocol;
        }

        public Boolean getReconnectOnChangedSchema() {
            return this._reconnectOnChangedSchema;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev240911.rpc.credentials.RpcCredentials getRpcCredentials() {
            return this._rpcCredentials;
        }

        public String getSchemaCacheDirectory() {
            return this._schemaCacheDirectory;
        }

        public Boolean getSchemaless() {
            return this._schemaless;
        }

        public Boolean getTcpOnly() {
            return this._tcpOnly;
        }

        public YangLibrary getYangLibrary() {
            return this._yangLibrary;
        }

        public YangModuleCapabilities getYangModuleCapabilities() {
            return this._yangModuleCapabilities;
        }

        @Override
        public IgnoreMissingSchemaSources nonnullIgnoreMissingSchemaSources() {
            return Objects.requireNonNullElse(this.getIgnoreMissingSchemaSources(), IgnoreMissingSchemaSourcesBuilder.empty());
        }

        public NonModuleCapabilities nonnullNonModuleCapabilities() {
            return Objects.requireNonNullElse(this.getNonModuleCapabilities(), NonModuleCapabilitiesBuilder.empty());
        }

        public OdlHelloMessageCapabilities nonnullOdlHelloMessageCapabilities() {
            return Objects.requireNonNullElse(this.getOdlHelloMessageCapabilities(), OdlHelloMessageCapabilitiesBuilder.empty());
        }

        public Protocol nonnullProtocol() {
            return Objects.requireNonNullElse(this.getProtocol(), ProtocolBuilder.empty());
        }

        public YangLibrary nonnullYangLibrary() {
            return Objects.requireNonNullElse(this.getYangLibrary(), YangLibraryBuilder.empty());
        }

        public YangModuleCapabilities nonnullYangModuleCapabilities() {
            return Objects.requireNonNullElse(this.getYangModuleCapabilities(), YangModuleCapabilitiesBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = CreateDeviceInput.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return CreateDeviceInput.bindingEquals(this, obj);
        }

        public String toString() {
            return CreateDeviceInput.bindingToString(this);
        }
    }
}

