/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.errors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public class RestconfDocumentedException
extends RuntimeException {
    private static final long serialVersionUID = 3L;
    private final List<RestconfError> errors;
    private final transient @Nullable EffectiveModelContext modelContext;

    public RestconfDocumentedException(String message) {
        this(message, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED);
    }

    public RestconfDocumentedException(String message, ErrorType errorType, ErrorTag errorTag, Throwable cause) {
        this(cause, new RestconfError(errorType, errorTag, message, null, cause.getMessage(), null));
    }

    public RestconfDocumentedException(String message, ErrorType errorType, ErrorTag errorTag) {
        this(new RestconfError(errorType, errorTag, message));
    }

    public RestconfDocumentedException(String message, ErrorType errorType, ErrorTag errorTag, YangInstanceIdentifier errorPath) {
        this(new RestconfError(errorType, errorTag, message, errorPath));
    }

    public RestconfDocumentedException(String message, Throwable cause) {
        this(cause, new RestconfError(ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, message, null, cause.getMessage(), null));
    }

    public RestconfDocumentedException(RestconfError error) {
        this(null, error);
    }

    public RestconfDocumentedException(String message, Throwable cause, List<RestconfError> errors) {
        super(cause);
        this.errors = errors.isEmpty() ? List.of(new RestconfError(ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, message)) : List.copyOf(errors);
        this.modelContext = null;
    }

    public RestconfDocumentedException(String message, Throwable cause, Collection<? extends RpcError> rpcErrors) {
        this(message, cause, RestconfDocumentedException.convertToRestconfErrors(rpcErrors));
    }

    private static List<RestconfError> convertToRestconfErrors(Collection<? extends RpcError> rpcErrors) {
        if (rpcErrors == null || rpcErrors.isEmpty()) {
            return List.of();
        }
        ArrayList<RestconfError> errorList = new ArrayList<RestconfError>();
        for (RpcError rpcError : rpcErrors) {
            errorList.add(new RestconfError(rpcError));
        }
        return errorList;
    }

    public RestconfDocumentedException(Throwable cause, RestconfError error) {
        super(cause);
        this.errors = List.of(error);
        this.modelContext = null;
    }

    public RestconfDocumentedException(Throwable cause, RestconfError error, EffectiveModelContext modelContext) {
        super(cause);
        this.errors = List.of(error);
        this.modelContext = Objects.requireNonNull(modelContext);
    }

    public RestconfDocumentedException(Throwable cause, List<RestconfError> errors) {
        super(cause);
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("At least one error is required");
        }
        this.errors = List.copyOf(errors);
        this.modelContext = null;
    }

    @Override
    public String getMessage() {
        return "errors: " + this.errors;
    }

    public @Nullable EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public List<RestconfError> getErrors() {
        return this.errors;
    }
}

