/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.errors;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class RestconfError
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull ErrorType errorType;
    private final @NonNull ErrorTag errorTag;
    private final String errorInfo;
    private final String errorAppTag;
    private final String errorMessage;
    private final YangInstanceIdentifier errorPath;

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage) {
        this(errorType, errorTag, errorMessage, null, null, null);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, String errorAppTag) {
        this(errorType, errorTag, errorMessage, errorAppTag, null, null);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, YangInstanceIdentifier errorPath) {
        this(errorType, errorTag, errorMessage, null, null, errorPath);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, String errorAppTag, String errorInfo) {
        this(errorType, errorTag, errorMessage, errorAppTag, errorInfo, null);
    }

    public RestconfError(ErrorType errorType, ErrorTag errorTag, String errorMessage, String errorAppTag, String errorInfo, YangInstanceIdentifier errorPath) {
        this.errorType = Objects.requireNonNull(errorType, "Error type is required for RestConfError");
        this.errorTag = Objects.requireNonNull(errorTag, "Error tag is required for RestConfError");
        this.errorMessage = errorMessage;
        this.errorAppTag = errorAppTag;
        this.errorInfo = errorInfo;
        this.errorPath = errorPath;
    }

    public RestconfError(RpcError rpcError) {
        this.errorType = rpcError.getErrorType();
        ErrorTag tag = rpcError.getTag();
        this.errorTag = tag != null ? tag : ErrorTag.OPERATION_FAILED;
        this.errorMessage = rpcError.getMessage();
        this.errorAppTag = rpcError.getApplicationTag();
        this.errorInfo = RestconfError.rpcErrorInfo(rpcError);
        this.errorPath = null;
    }

    private static String rpcErrorInfo(RpcError rpcError) {
        String info = rpcError.getInfo();
        if (info != null) {
            return info;
        }
        Throwable cause = rpcError.getCause();
        if (cause != null) {
            return cause.getMessage();
        }
        ErrorSeverity severity = rpcError.getSeverity();
        if (severity != null) {
            return "<severity>" + severity.elementBody() + "</severity>";
        }
        return null;
    }

    public @NonNull ErrorType getErrorType() {
        return this.errorType;
    }

    public @NonNull ErrorTag getErrorTag() {
        return this.errorTag;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public String getErrorAppTag() {
        return this.errorAppTag;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public YangInstanceIdentifier getErrorPath() {
        return this.errorPath;
    }

    public String toString() {
        return "RestconfError [error-type: " + this.errorType.elementBody() + ", error-tag: " + this.errorTag.elementBody() + (String)(this.errorAppTag != null ? ", error-app-tag: " + this.errorAppTag : "") + (String)(this.errorMessage != null ? ", error-message: " + this.errorMessage : "") + (String)(this.errorInfo != null ? ", error-info: " + this.errorInfo : "") + (String)(this.errorPath != null ? ", error-path: " + this.errorPath.toString() : "") + "]";
    }
}

