/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.common.errors;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.restconf.common.errors.RestconfCallback;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class RestconfFuture<V>
extends AbstractFuture<V> {
    RestconfFuture() {
    }

    public static <V> @NonNull RestconfFuture<V> of(V value) {
        RestconfFuture<V> future = new RestconfFuture<V>();
        future.set(Objects.requireNonNull(value));
        return future;
    }

    public static <V> @NonNull RestconfFuture<V> failed(RestconfDocumentedException cause) {
        RestconfFuture<V> future = new RestconfFuture<V>();
        future.setException(Objects.requireNonNull(cause));
        return future;
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public final @NonNull RestconfFuture<V> addCallback(RestconfCallback<? super V> callback) {
        Futures.addCallback((ListenableFuture)this, callback, (Executor)MoreExecutors.directExecutor());
        return this;
    }

    public final <T> @NonNull RestconfFuture<T> transform(Function<@NonNull V, @NonNull T> function) {
        final Function<V, T> fun = Objects.requireNonNull(function);
        final RestconfFuture<V> ret = new RestconfFuture<V>();
        this.addCallback(new RestconfCallback<V>(){

            public void onSuccess(V result) {
                ret.set(Objects.requireNonNull(fun.apply(result)));
            }

            @Override
            protected void onFailure(RestconfDocumentedException failure) {
                ret.setException(failure);
            }
        });
        return ret;
    }

    public final @NonNull V getOrThrow() {
        try {
            return (V)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RestconfDocumentedException("Interrupted while waiting", e);
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), RestconfDocumentedException.class);
            throw new RestconfDocumentedException("Operation failed", e);
        }
    }
}

