/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.datatype;

import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.datatype.AbstractDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.DatatypeID;
import org.opendaylight.netconf.shaded.exificient.core.types.BuiltInType;
import org.opendaylight.netconf.shaded.exificient.core.util.MethodsBag;
import org.opendaylight.netconf.shaded.exificient.core.values.IntegerValue;

public class NBitUnsignedIntegerDatatype
extends AbstractDatatype {
    protected IntegerValue validValue;
    protected final IntegerValue lowerBound;
    protected final IntegerValue upperBound;
    protected final int numberOfBits4Range;

    public NBitUnsignedIntegerDatatype(IntegerValue lowerBound, IntegerValue upperBound, QNameContext schemaType) {
        super(BuiltInType.NBIT_UNSIGNED_INTEGER, schemaType);
        assert (upperBound.compareTo(lowerBound) >= 0);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        IntegerValue diff = upperBound.subtract(lowerBound);
        this.numberOfBits4Range = MethodsBag.getCodingLength(diff.intValue() + 1);
    }

    public DatatypeID getDatatypeID() {
        return DatatypeID.exi_integer;
    }

    public IntegerValue getLowerBound() {
        return this.lowerBound;
    }

    public IntegerValue getUpperBound() {
        return this.upperBound;
    }

    public int getNumberOfBits() {
        return this.numberOfBits4Range;
    }

    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof NBitUnsignedIntegerDatatype) {
            NBitUnsignedIntegerDatatype nb = (NBitUnsignedIntegerDatatype)o;
            return this.lowerBound.equals(nb.lowerBound) && this.upperBound.equals(nb.upperBound);
        }
        return false;
    }
}

