/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.datatype.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.AbstractStringCoder;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.StringCoder;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.StringDecoder;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.DecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.util.MethodsBag;
import org.opendaylight.netconf.shaded.exificient.core.values.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringDecoderImpl
extends AbstractStringCoder
implements StringDecoder {
    protected List<StringValue> globalValues = new ArrayList<StringValue>();

    public StringDecoderImpl(boolean localValuePartitions) {
        this(localValuePartitions, 60);
    }

    public StringDecoderImpl(boolean localValuePartitions, int initialQNameLists) {
        super(localValuePartitions, initialQNameLists);
    }

    @Override
    public StringValue readValue(QNameContext context, DecoderChannel valueChannel) throws IOException {
        StringValue value;
        int i = valueChannel.decodeUnsignedInteger();
        switch (i) {
            case 0: {
                if (this.localValuePartitions) {
                    value = this.readValueLocalHit(context, valueChannel);
                    break;
                }
                throw new IOException("EXI stream contains local-value hit even though profile options indicate otherwise.");
            }
            case 1: {
                value = this.readValueGlobalHit(valueChannel);
                break;
            }
            default: {
                int L = i - 2;
                if (L > 0) {
                    value = new StringValue(valueChannel.decodeStringOnly(L));
                    this.addValue(context, value);
                    break;
                }
                value = StringCoder.EMPTY_STRING_VALUE;
            }
        }
        assert (value != null);
        return value;
    }

    @Override
    public StringValue readValueLocalHit(QNameContext qnc, DecoderChannel valueChannel) throws IOException {
        assert (this.localValuePartitions);
        int n = MethodsBag.getCodingLength(this.getNumberOfStringValues(qnc));
        int localID = valueChannel.decodeNBitUnsignedInteger(n);
        List lvs = (List)this.localValues.get(qnc);
        assert (lvs != null);
        assert (localID < lvs.size());
        return (StringValue)lvs.get(localID);
    }

    @Override
    public final StringValue readValueGlobalHit(DecoderChannel valueChannel) throws IOException {
        int numberBitsGlobal = MethodsBag.getCodingLength(this.globalValues.size());
        int globalID = valueChannel.decodeNBitUnsignedInteger(numberBitsGlobal);
        return this.globalValues.get(globalID);
    }

    @Override
    public void addValue(QNameContext qnc, StringValue value) {
        assert (!this.globalValues.contains(value));
        this.globalValues.add(value);
        this.addLocalValue(qnc, value);
    }

    @Override
    public void clear() {
        super.clear();
        this.globalValues.clear();
    }

    @Override
    public void setSharedStrings(List<String> sharedStrings) {
        for (String s : sharedStrings) {
            this.addValue(null, new StringValue(s));
        }
    }
}

