/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.grammars.grammar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Attribute;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Event;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EventType;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.AbstractGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.BuiltInGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Grammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.production.Production;
import org.opendaylight.netconf.shaded.exificient.core.grammars.production.SchemaLessProduction;
import org.opendaylight.netconf.shaded.exificient.core.util.MethodsBag;

public abstract class AbstractBuiltInGrammar
extends AbstractGrammar
implements BuiltInGrammar {
    protected List<Production> containers = new ArrayList<Production>();
    protected int ec1Length = 0;

    public boolean hasEndElement() {
        return false;
    }

    public void stopLearning() {
        if (this.stopLearningContainerSize == -1) {
            this.stopLearningContainerSize = this.containers.size();
        }
    }

    public final boolean isSchemaInformed() {
        return false;
    }

    public Grammar getTypeEmpty() {
        return this;
    }

    public int getNumberOfEvents() {
        return this.containers.size();
    }

    public void addProduction(Event event, Grammar grammar) {
        this.containers.add(new SchemaLessProduction(this, grammar, event, this.getNumberOfEvents()));
        this.ec1Length = MethodsBag.getCodingLength(this.containers.size() + 1);
    }

    protected boolean contains(Event event) {
        Iterator<Production> iter = this.containers.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getEvent().equals(event)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getLabel() + "//\t");
        sb.append("[");
        for (int ec = 0; ec < this.getNumberOfEvents(); ++ec) {
            sb.append("," + this.getProduction(ec).getEvent());
        }
        sb.append("]");
        return sb.toString();
    }

    public Production getProduction(EventType eventType) {
        for (int i = 0; i < this.containers.size(); ++i) {
            Production ei = this.containers.get(i);
            if (!ei.getEvent().isEventType(eventType) || this.isExiProfilGhostNode(ei)) continue;
            return ei;
        }
        return null;
    }

    private final boolean isExiProfilGhostNode(Production ei) {
        if (this.stopLearningContainerSize == -1) {
            return false;
        }
        return ei.getEventCode() < this.getNumberOfEvents() - this.stopLearningContainerSize;
    }

    public Production getStartElementProduction(String namespaceURI, String localName) {
        for (int i = 0; i < this.containers.size(); ++i) {
            Production ei = this.containers.get(i);
            if (!ei.getEvent().isEventType(EventType.START_ELEMENT) || !AbstractBuiltInGrammar.checkQualifiedName(((StartElement)ei.getEvent()).getQName(), namespaceURI, localName) || this.isExiProfilGhostNode(ei)) continue;
            return ei;
        }
        return null;
    }

    public Production getStartElementNSProduction(String namespaceURI) {
        return null;
    }

    public Production getAttributeProduction(String namespaceURI, String localName) {
        for (int i = 0; i < this.containers.size(); ++i) {
            Production ei = this.containers.get(i);
            if (!ei.getEvent().isEventType(EventType.ATTRIBUTE) || !AbstractBuiltInGrammar.checkQualifiedName(((Attribute)ei.getEvent()).getQName(), namespaceURI, localName) || this.isExiProfilGhostNode(ei)) continue;
            return ei;
        }
        return null;
    }

    public Production getAttributeNSProduction(String namespaceURI) {
        return null;
    }

    public Production getProduction(int eventCode) {
        assert (eventCode >= 0 && eventCode < this.containers.size());
        return this.containers.get(this.getNumberOfEvents() - 1 - eventCode);
    }
}

