/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.io.channel;

import java.io.IOException;
import java.math.BigInteger;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.EncoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.util.MethodsBag;
import org.opendaylight.netconf.shaded.exificient.core.values.DateTimeValue;
import org.opendaylight.netconf.shaded.exificient.core.values.FloatValue;
import org.opendaylight.netconf.shaded.exificient.core.values.IntegerValue;

public abstract class AbstractEncoderChannel
implements EncoderChannel {
    public void encodeBinary(byte[] b) throws IOException {
        this.encodeUnsignedInteger(b.length);
        this.encode(b, 0, b.length);
    }

    public void encodeString(String s) throws IOException {
        int lenChars = s.length();
        int lenCharacters = s.codePointCount(0, lenChars);
        this.encodeUnsignedInteger(lenCharacters);
        this.encodeStringOnly(s);
    }

    public void encodeStringOnly(String s) throws IOException {
        int lenChars = s.length();
        for (int i = 0; i < lenChars; ++i) {
            char ch = s.charAt(i);
            if (Character.isHighSurrogate(ch)) {
                this.encodeUnsignedInteger(s.codePointAt(i++));
                continue;
            }
            this.encodeUnsignedInteger(ch);
        }
    }

    public void encodeInteger(int n) throws IOException {
        if (n < 0) {
            this.encodeBoolean(true);
            this.encodeUnsignedInteger(-n - 1);
        } else {
            this.encodeBoolean(false);
            this.encodeUnsignedInteger(n);
        }
    }

    protected void encodeLong(long l) throws IOException {
        if (l < 0L) {
            this.encodeBoolean(true);
            this.encodeUnsignedLong(-l - 1L);
        } else {
            this.encodeBoolean(false);
            this.encodeUnsignedLong(l);
        }
    }

    protected void encodeBigInteger(BigInteger bi) throws IOException {
        if (bi.signum() < 0) {
            this.encodeBoolean(true);
            this.encodeUnsignedBigInteger(bi.negate().subtract(BigInteger.ONE));
        } else {
            this.encodeBoolean(false);
            this.encodeUnsignedBigInteger(bi);
        }
    }

    public void encodeIntegerValue(IntegerValue iv) throws IOException {
        switch (iv.getIntegerValueType()) {
            case INT: {
                this.encodeInteger(iv.intValue());
                break;
            }
            case LONG: {
                this.encodeLong(iv.longValue());
                break;
            }
            case BIG: {
                this.encodeBigInteger(iv.bigIntegerValue());
                break;
            }
            default: {
                throw new IOException("Unexpcted EXI integer value type " + (Object)((Object)iv.getValueType()));
            }
        }
    }

    public void encodeUnsignedInteger(int n) throws IOException {
        if (n < 0) {
            throw new UnsupportedOperationException();
        }
        if (n < 128) {
            this.encode(n);
        } else {
            int n7BitBlocks = MethodsBag.numberOf7BitBlocksToRepresent(n);
            switch (n7BitBlocks) {
                case 5: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 4: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 3: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 2: {
                    this.encode(0x80 | n);
                    n >>>= 7;
                }
                case 1: {
                    this.encode(0 | n);
                }
            }
        }
    }

    protected void encodeUnsignedLong(long l) throws IOException {
        if (l < 0L) {
            throw new UnsupportedOperationException();
        }
        int lastEncode = (int)l;
        l >>>= 7;
        while (l != 0L) {
            this.encode(lastEncode | 0x80);
            lastEncode = (int)l;
            l >>>= 7;
        }
        this.encode(lastEncode);
    }

    protected void encodeUnsignedBigInteger(BigInteger bi) throws IOException {
        if (bi.signum() < 0) {
            throw new UnsupportedOperationException();
        }
        int m = bi.bitLength() % 7;
        int nbytes = bi.bitLength() / 7 + (m > 0 ? 1 : 0);
        while (--nbytes > 0) {
            this.encode(0x80 | bi.intValue());
            bi = bi.shiftRight(7);
        }
        this.encode(0 | bi.intValue());
    }

    public void encodeUnsignedIntegerValue(IntegerValue iv) throws IOException {
        switch (iv.getIntegerValueType()) {
            case INT: {
                this.encodeUnsignedInteger(iv.intValue());
                break;
            }
            case LONG: {
                this.encodeUnsignedLong(iv.longValue());
                break;
            }
            case BIG: {
                this.encodeUnsignedBigInteger(iv.bigIntegerValue());
                break;
            }
            default: {
                throw new IOException("Unexpcted EXI integer value type " + (Object)((Object)iv.getValueType()));
            }
        }
    }

    public void encodeDecimal(boolean negative, IntegerValue integral, IntegerValue reverseFraction) throws IOException, RuntimeException {
        this.encodeBoolean(negative);
        this.encodeUnsignedIntegerValue(integral);
        this.encodeUnsignedIntegerValue(reverseFraction);
    }

    public void encodeFloat(FloatValue fv) throws IOException {
        this.encodeIntegerValue(fv.getMantissa());
        this.encodeIntegerValue(fv.getExponent());
    }

    public void encodeDateTime(DateTimeValue datetime) throws IOException {
        switch (datetime.type) {
            case gYear: {
                this.encodeInteger(datetime.year - 2000);
                break;
            }
            case gYearMonth: 
            case date: {
                this.encodeInteger(datetime.year - 2000);
                this.encodeNBitUnsignedInteger(datetime.monthDay, 9);
                break;
            }
            case dateTime: {
                this.encodeInteger(datetime.year - 2000);
                this.encodeNBitUnsignedInteger(datetime.monthDay, 9);
            }
            case time: {
                this.encodeNBitUnsignedInteger(datetime.time, 17);
                if (datetime.presenceFractionalSecs) {
                    this.encodeBoolean(true);
                    this.encodeUnsignedInteger(datetime.fractionalSecs);
                    break;
                }
                this.encodeBoolean(false);
                break;
            }
            case gMonth: 
            case gMonthDay: 
            case gDay: {
                this.encodeNBitUnsignedInteger(datetime.monthDay, 9);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (datetime.presenceTimezone) {
            this.encodeBoolean(true);
            this.encodeNBitUnsignedInteger(datetime.timezone + 896, 11);
        } else {
            this.encodeBoolean(false);
        }
    }
}

