/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.types;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.datatype.Datatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.RestrictedCharacterSetDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.charset.RestrictedCharacterSet;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.StringCoder;
import org.opendaylight.netconf.shaded.exificient.core.datatype.strings.StringDecoder;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.DecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.types.AbstractTypeCoder;
import org.opendaylight.netconf.shaded.exificient.core.types.TypeDecoder;
import org.opendaylight.netconf.shaded.exificient.core.values.StringValue;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeDecoder
extends AbstractTypeCoder
implements TypeDecoder {
    public AbstractTypeDecoder() throws EXIException {
        this(null, null, null);
    }

    public AbstractTypeDecoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype);
    }

    protected Value readRCSValue(RestrictedCharacterSetDatatype rcsDT, QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        StringValue value;
        RestrictedCharacterSet rcs = rcsDT.getRestrictedCharacterSet();
        int i = valueChannel.decodeUnsignedInteger();
        if (i == 0) {
            value = stringDecoder.readValueLocalHit(qnContext, valueChannel);
        } else if (i == 1) {
            value = stringDecoder.readValueGlobalHit(valueChannel);
        } else {
            int L = i - 2;
            if (L > 0) {
                int numberOfBits = rcs.getCodingLength();
                int size = rcs.size();
                char[] cValue = new char[L];
                value = new StringValue(cValue);
                for (int k = 0; k < L; ++k) {
                    int code = valueChannel.decodeNBitUnsignedInteger(numberOfBits);
                    int codePoint = code == size ? valueChannel.decodeUnsignedInteger() : rcs.getCodePoint(code);
                    Character.toChars(codePoint, cValue, k);
                }
                stringDecoder.addValue(qnContext, value);
            } else {
                value = StringCoder.EMPTY_STRING_VALUE;
            }
        }
        return value;
    }
}

