/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.xerces.impl.xs;

import org.opendaylight.netconf.shaded.xerces.impl.dv.ValidatedInfo;
import org.opendaylight.netconf.shaded.xerces.impl.xs.PSVIErrorList;
import org.opendaylight.netconf.shaded.xerces.impl.xs.util.StringListImpl;
import org.opendaylight.netconf.shaded.xerces.xs.AttributePSVI;
import org.opendaylight.netconf.shaded.xerces.xs.ItemPSVI;
import org.opendaylight.netconf.shaded.xerces.xs.ShortList;
import org.opendaylight.netconf.shaded.xerces.xs.StringList;
import org.opendaylight.netconf.shaded.xerces.xs.XSAttributeDeclaration;
import org.opendaylight.netconf.shaded.xerces.xs.XSSimpleTypeDefinition;
import org.opendaylight.netconf.shaded.xerces.xs.XSTypeDefinition;
import org.opendaylight.netconf.shaded.xerces.xs.XSValue;

public class AttributePSVImpl
implements AttributePSVI {
    protected XSAttributeDeclaration fDeclaration = null;
    protected XSTypeDefinition fTypeDecl = null;
    protected boolean fSpecified = false;
    protected ValidatedInfo fValue = new ValidatedInfo();
    protected short fValidationAttempted = 0;
    protected short fValidity = 0;
    protected String[] fErrors = null;
    protected String fValidationContext = null;
    protected boolean fIsConstant;

    public AttributePSVImpl() {
    }

    public AttributePSVImpl(boolean bl, AttributePSVI attributePSVI) {
        this.fDeclaration = attributePSVI.getAttributeDeclaration();
        this.fTypeDecl = attributePSVI.getTypeDefinition();
        this.fSpecified = attributePSVI.getIsSchemaSpecified();
        this.fValue.copyFrom(attributePSVI.getSchemaValue());
        this.fValidationAttempted = attributePSVI.getValidationAttempted();
        this.fValidity = attributePSVI.getValidity();
        if (attributePSVI instanceof AttributePSVImpl) {
            AttributePSVImpl attributePSVImpl = (AttributePSVImpl)attributePSVI;
            this.fErrors = attributePSVImpl.fErrors != null ? (String[])attributePSVImpl.fErrors.clone() : null;
        } else {
            StringList stringList = attributePSVI.getErrorCodes();
            int n = stringList.getLength();
            if (n > 0) {
                StringList stringList2 = attributePSVI.getErrorMessages();
                String[] stringArray = new String[n << 1];
                int n2 = 0;
                int n3 = 0;
                while (n2 < n) {
                    stringArray[n3++] = stringList.item(n2);
                    stringArray[n3++] = stringList2.item(n2);
                    ++n2;
                }
                this.fErrors = stringArray;
            }
        }
        this.fValidationContext = attributePSVI.getValidationContext();
        this.fIsConstant = bl;
    }

    public ItemPSVI constant() {
        if (this.isConstant()) {
            return this;
        }
        return new AttributePSVImpl(true, this);
    }

    public boolean isConstant() {
        return this.fIsConstant;
    }

    public String getSchemaDefault() {
        return this.fDeclaration == null ? null : this.fDeclaration.getConstraintValue();
    }

    public String getSchemaNormalizedValue() {
        return this.fValue.getNormalizedValue();
    }

    public boolean getIsSchemaSpecified() {
        return this.fSpecified;
    }

    public short getValidationAttempted() {
        return this.fValidationAttempted;
    }

    public short getValidity() {
        return this.fValidity;
    }

    public StringList getErrorCodes() {
        if (this.fErrors == null || this.fErrors.length == 0) {
            return StringListImpl.EMPTY_LIST;
        }
        return new PSVIErrorList(this.fErrors, true);
    }

    public StringList getErrorMessages() {
        if (this.fErrors == null || this.fErrors.length == 0) {
            return StringListImpl.EMPTY_LIST;
        }
        return new PSVIErrorList(this.fErrors, false);
    }

    public String getValidationContext() {
        return this.fValidationContext;
    }

    public XSTypeDefinition getTypeDefinition() {
        return this.fTypeDecl;
    }

    public XSSimpleTypeDefinition getMemberTypeDefinition() {
        return this.fValue.getMemberTypeDefinition();
    }

    public XSAttributeDeclaration getAttributeDeclaration() {
        return this.fDeclaration;
    }

    public Object getActualNormalizedValue() {
        return this.fValue.getActualValue();
    }

    public short getActualNormalizedValueType() {
        return this.fValue.getActualValueType();
    }

    public ShortList getItemValueTypes() {
        return this.fValue.getListValueTypes();
    }

    public XSValue getSchemaValue() {
        return this.fValue;
    }

    public void reset() {
        this.fValue.reset();
        this.fDeclaration = null;
        this.fTypeDecl = null;
        this.fSpecified = false;
        this.fValidationAttempted = 0;
        this.fValidity = 0;
        this.fErrors = null;
        this.fValidationContext = null;
    }
}

