/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.core.io.channel;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.AbstractDecoderChannel;
import org.opendaylight.netconf.shaded.exificient.core.io.channel.DecoderChannel;

public class ByteDecoderChannel
extends AbstractDecoderChannel
implements DecoderChannel {
    protected InputStream is;

    public ByteDecoderChannel(InputStream istream) {
        this.is = istream;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public int decode() throws IOException {
        int b = this.is.read();
        if (b == -1) {
            throw new EOFException("Premature EOS found while reading data.");
        }
        return b;
    }

    public void align() throws IOException {
    }

    public void skip(long n) throws IOException {
        while (n != 0L) {
            n -= this.is.skip(n);
        }
    }

    public int decodeNBitUnsignedInteger(int n) throws IOException {
        assert (n >= 0);
        int result = 0;
        for (int bitsRead = 0; bitsRead < n; bitsRead += 8) {
            result += this.decode() << bitsRead;
        }
        return result;
    }

    public boolean decodeBoolean() throws IOException {
        return this.decode() != 0;
    }

    public byte[] decodeBinary() throws IOException {
        int len;
        int length = this.decodeUnsignedInteger();
        byte[] result = new byte[length];
        for (int readBytes = 0; readBytes < length; readBytes += len) {
            len = this.is.read(result, readBytes, length - readBytes);
            if (len != -1) continue;
            throw new EOFException("Premature EOS found while reading data.");
        }
        return result;
    }
}

