/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.grammars;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.opendaylight.netconf.shaded.exificient.core.Constants;
import org.opendaylight.netconf.shaded.exificient.core.context.GrammarContext;
import org.opendaylight.netconf.shaded.exificient.core.context.GrammarUriContext;
import org.opendaylight.netconf.shaded.exificient.core.context.QNameContext;
import org.opendaylight.netconf.shaded.exificient.core.datatype.AbstractDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.BinaryBase64Datatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.BinaryHexDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.BooleanDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.BooleanFacetDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.Datatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.DatetimeDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.DecimalDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.EnumerationDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.FloatDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.IntegerDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.ListDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.NBitUnsignedIntegerDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.RestrictedCharacterSetDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.StringDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.UnsignedIntegerDatatype;
import org.opendaylight.netconf.shaded.exificient.core.datatype.WhiteSpace;
import org.opendaylight.netconf.shaded.exificient.core.datatype.charset.CodePointCharacterSet;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.core.grammars.Grammars;
import org.opendaylight.netconf.shaded.exificient.core.grammars.SchemaInformedGrammars;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Attribute;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.AttributeNS;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Characters;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.DatatypeEvent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EndDocument;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.Event;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.EventType;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartDocument;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.event.StartElementNS;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.DocEnd;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Document;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.Fragment;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedDocContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedElement;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFirstStartTag;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedFragmentContent;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedStartTag;
import org.opendaylight.netconf.shaded.exificient.core.grammars.grammar.SchemaInformedStartTagGrammar;
import org.opendaylight.netconf.shaded.exificient.core.grammars.production.Production;
import org.opendaylight.netconf.shaded.exificient.core.types.BuiltIn;
import org.opendaylight.netconf.shaded.exificient.core.types.BuiltInType;
import org.opendaylight.netconf.shaded.exificient.core.types.DateTimeType;
import org.opendaylight.netconf.shaded.exificient.core.types.IntegerType;
import org.opendaylight.netconf.shaded.exificient.core.types.TypedTypeEncoder;
import org.opendaylight.netconf.shaded.exificient.core.values.AbstractValue;
import org.opendaylight.netconf.shaded.exificient.core.values.BinaryBase64Value;
import org.opendaylight.netconf.shaded.exificient.core.values.BinaryHexValue;
import org.opendaylight.netconf.shaded.exificient.core.values.BooleanValue;
import org.opendaylight.netconf.shaded.exificient.core.values.DateTimeValue;
import org.opendaylight.netconf.shaded.exificient.core.values.DecimalValue;
import org.opendaylight.netconf.shaded.exificient.core.values.FloatValue;
import org.opendaylight.netconf.shaded.exificient.core.values.IntegerValue;
import org.opendaylight.netconf.shaded.exificient.core.values.StringValue;
import org.opendaylight.netconf.shaded.exificient.core.values.Value;
import org.opendaylight.netconf.shaded.exificient.grammars.EXIContentModelBuilder;
import org.opendaylight.netconf.shaded.exificient.grammars.GrammarAnnotationFilter;
import org.opendaylight.netconf.shaded.exificient.grammars.GrammarFactory;
import org.opendaylight.netconf.shaded.exificient.grammars.regex.EXIRegularExpression;
import org.opendaylight.netconf.shaded.xerces.xs.StringList;
import org.opendaylight.netconf.shaded.xerces.xs.XSAnnotation;
import org.opendaylight.netconf.shaded.xerces.xs.XSAttributeDeclaration;
import org.opendaylight.netconf.shaded.xerces.xs.XSAttributeUse;
import org.opendaylight.netconf.shaded.xerces.xs.XSComplexTypeDefinition;
import org.opendaylight.netconf.shaded.xerces.xs.XSElementDeclaration;
import org.opendaylight.netconf.shaded.xerces.xs.XSFacet;
import org.opendaylight.netconf.shaded.xerces.xs.XSModel;
import org.opendaylight.netconf.shaded.xerces.xs.XSModelGroup;
import org.opendaylight.netconf.shaded.xerces.xs.XSMultiValueFacet;
import org.opendaylight.netconf.shaded.xerces.xs.XSNamedMap;
import org.opendaylight.netconf.shaded.xerces.xs.XSObject;
import org.opendaylight.netconf.shaded.xerces.xs.XSObjectList;
import org.opendaylight.netconf.shaded.xerces.xs.XSParticle;
import org.opendaylight.netconf.shaded.xerces.xs.XSSimpleTypeDefinition;
import org.opendaylight.netconf.shaded.xerces.xs.XSTerm;
import org.opendaylight.netconf.shaded.xerces.xs.XSTypeDefinition;
import org.opendaylight.netconf.shaded.xerces.xs.XSWildcard;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDGrammarsBuilder
extends EXIContentModelBuilder {
    public static final int MAX_BOUNDED_NBIT_INTEGER_RANGE = 4096;
    protected final SchemaInformedGrammar SIMPLE_END_ELEMENT_RULE = new SchemaInformedElement();
    protected final SchemaInformedFirstStartTagGrammar SIMPLE_END_ELEMENT_EMPTY_RULE;
    protected final SchemaInformedFirstStartTagGrammar SIMPLE_END_ELEMENT_EMPTY_RULE_TYPABLE;
    protected Map<QName, SchemaInformedFirstStartTagGrammar> grammarTypes;
    protected Map<String, List<String>> schemaLocalNames;
    protected Map<XSAttributeDeclaration, Attribute> attributePool;
    protected Map<XSSimpleTypeDefinition, Datatype> datatypePool;
    protected Map<QName, List<XSElementDeclaration>> uniqueNamedElements;
    protected SchemaInformedFirstStartTagGrammar elementFragment0;
    protected Map<QName, QName> datatypeMapping;
    GrammarUriContext[] grammarUriContexts;

    protected XSDGrammarsBuilder() {
        this.SIMPLE_END_ELEMENT_RULE.addTerminalProduction(END_ELEMENT);
        this.SIMPLE_END_ELEMENT_EMPTY_RULE = new SchemaInformedFirstStartTag(this.SIMPLE_END_ELEMENT_RULE);
        this.SIMPLE_END_ELEMENT_EMPTY_RULE.addTerminalProduction(END_ELEMENT);
        this.SIMPLE_END_ELEMENT_EMPTY_RULE_TYPABLE = new SchemaInformedFirstStartTag(this.SIMPLE_END_ELEMENT_RULE);
        this.SIMPLE_END_ELEMENT_EMPTY_RULE_TYPABLE.addTerminalProduction(END_ELEMENT);
        this.SIMPLE_END_ELEMENT_EMPTY_RULE_TYPABLE.setTypeCastable(true);
        this.initOnce();
    }

    public static XSDGrammarsBuilder newInstance() {
        return new XSDGrammarsBuilder();
    }

    @Override
    protected void initOnce() {
        super.initOnce();
        this.grammarTypes = new HashMap<QName, SchemaInformedFirstStartTagGrammar>();
        this.schemaLocalNames = new HashMap<String, List<String>>();
        this.attributePool = new HashMap<XSAttributeDeclaration, Attribute>();
        this.datatypePool = new HashMap<XSSimpleTypeDefinition, Datatype>();
        this.datatypeMapping = new HashMap<QName, QName>();
        this.datatypeMapping.put(BuiltIn.XSD_BASE64BINARY, BuiltIn.XSD_BASE64BINARY);
        this.datatypeMapping.put(BuiltIn.XSD_HEXBINARY, BuiltIn.XSD_HEXBINARY);
        this.datatypeMapping.put(BuiltIn.XSD_BOOLEAN, BuiltIn.XSD_BOOLEAN);
        this.datatypeMapping.put(BuiltIn.XSD_DATETIME, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_TIME, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_DATE, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_GYEARMONTH, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_GYEAR, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_GMONTHDAY, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_GDAY, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_GMONTH, BuiltIn.XSD_DATETIME);
        this.datatypeMapping.put(BuiltIn.XSD_DECIMAL, BuiltIn.XSD_DECIMAL);
        this.datatypeMapping.put(BuiltIn.XSD_FLOAT, BuiltIn.XSD_FLOAT);
        this.datatypeMapping.put(BuiltIn.XSD_DOUBLE, BuiltIn.XSD_DOUBLE);
        this.datatypeMapping.put(BuiltIn.XSD_INTEGER, BuiltIn.XSD_INTEGER);
        this.datatypeMapping.put(BuiltIn.XSD_STRING, BuiltIn.XSD_STRING);
        this.datatypeMapping.put(BuiltIn.XSD_ANY_SIMPLE_TYPE, BuiltIn.XSD_STRING);
    }

    @Override
    protected void initEachRun() {
        String localName;
        int i;
        super.initEachRun();
        this.grammarTypes.clear();
        this.schemaLocalNames.clear();
        this.attributePool.clear();
        this.datatypePool.clear();
        this.uniqueNamedElements = null;
        this.elementFragment0 = null;
        for (i = 0; i < Constants.LOCAL_NAMES_EMPTY.length; ++i) {
            localName = Constants.LOCAL_NAMES_EMPTY[i];
            this.addLocalNameStringEntry("", localName);
        }
        for (i = 0; i < Constants.LOCAL_NAMES_XML.length; ++i) {
            localName = Constants.LOCAL_NAMES_XML[i];
            this.addLocalNameStringEntry("http://www.w3.org/XML/1998/namespace", localName);
        }
        for (i = 0; i < Constants.LOCAL_NAMES_XSI.length; ++i) {
            localName = Constants.LOCAL_NAMES_XSI[i];
            this.addLocalNameStringEntry("http://www.w3.org/2001/XMLSchema-instance", localName);
        }
        for (i = 0; i < Constants.LOCAL_NAMES_XSD.length; ++i) {
            localName = Constants.LOCAL_NAMES_XSD[i];
            this.addLocalNameStringEntry("http://www.w3.org/2001/XMLSchema", localName);
        }
    }

    protected StartElement createStartElement(QName qname) {
        QNameContext qnameContext = XSDGrammarsBuilder.getQNameContext(qname.getNamespaceURI(), qname.getLocalPart(), this.grammarUriContexts);
        StartElement se = new StartElement(qnameContext);
        return se;
    }

    @Override
    protected StartElementNS createStartElementNS(String uri) {
        GrammarUriContext uriContext = XSDGrammarsBuilder.getUriContext(uri, this.grammarUriContexts);
        StartElementNS seNS = new StartElementNS(uriContext.getNamespaceUriID(), uriContext.getNamespaceUri());
        return seNS;
    }

    protected static QNameContext getQNameContext(String namespaceUri, String localName, GrammarUriContext[] grammarUriContexts) {
        GrammarUriContext guc = XSDGrammarsBuilder.getUriContext(namespaceUri = namespaceUri == null ? "" : namespaceUri, grammarUriContexts);
        if (guc == null) {
            throw new RuntimeException("No known uri : " + namespaceUri);
        }
        QNameContext qnameContext = guc.getQNameContext(localName);
        if (qnameContext == null) {
            throw new RuntimeException("No known qname local-name: " + localName);
        }
        return qnameContext;
    }

    public static GrammarUriContext getUriContext(String namespaceUri, GrammarUriContext[] grammarUriContexts) {
        String string = namespaceUri = namespaceUri == null ? "" : namespaceUri;
        assert (grammarUriContexts != null);
        for (int i = 0; i < grammarUriContexts.length; ++i) {
            GrammarUriContext guc = grammarUriContexts[i];
            if (!guc.getNamespaceUri().equals(namespaceUri)) continue;
            return guc;
        }
        throw new RuntimeException("No known uri context for: " + namespaceUri);
    }

    protected Attribute createAttribute(QName qname, Datatype datatype) {
        QNameContext qnameContext = XSDGrammarsBuilder.getQNameContext(qname.getNamespaceURI(), qname.getLocalPart(), this.grammarUriContexts);
        Attribute at = new Attribute(qnameContext, datatype);
        return at;
    }

    protected AttributeNS createAttributeNS(String uri) {
        GrammarUriContext uriContext = XSDGrammarsBuilder.getUriContext(uri, this.grammarUriContexts);
        AttributeNS atNS = new AttributeNS(uriContext.getNamespaceUriID(), uriContext.getNamespaceUri());
        return atNS;
    }

    protected boolean isSameElementGrammar(List<XSElementDeclaration> elements) {
        assert (elements.size() > 1);
        for (int i = 1; i < elements.size(); ++i) {
            XSElementDeclaration e0 = elements.get(0);
            XSTypeDefinition t0 = e0.getTypeDefinition();
            XSElementDeclaration e1 = elements.get(i);
            XSTypeDefinition t1 = e1.getTypeDefinition();
            if (t0.getAnonymous() || t1.getAnonymous()) {
                return false;
            }
            if (t0.getName().equals(t1.getName()) && t0.getNamespace() == t1.getNamespace() && e0.getNillable() == e1.getNillable()) continue;
            return false;
        }
        return true;
    }

    protected boolean isSameAttributeGrammar(List<XSAttributeDeclaration> attributes) {
        assert (attributes.size() > 1);
        for (int i = 1; i < attributes.size(); ++i) {
            XSAttributeDeclaration e0 = attributes.get(0);
            XSAttributeDeclaration ei = attributes.get(i);
            if (e0.getTypeDefinition() == ei.getTypeDefinition()) continue;
            return false;
        }
        return true;
    }

    protected Map<QName, List<XSElementDeclaration>> getUniqueNamedElements() {
        if (this.uniqueNamedElements != null) {
            return this.uniqueNamedElements;
        }
        this.uniqueNamedElements = new HashMap<QName, List<XSElementDeclaration>>();
        for (XSElementDeclaration elDecl : this.elementPool.keySet()) {
            QName en = new QName(elDecl.getNamespace(), elDecl.getName());
            if (this.uniqueNamedElements.containsKey(en)) {
                this.uniqueNamedElements.get(en).add(elDecl);
                continue;
            }
            ArrayList<XSElementDeclaration> list = new ArrayList<XSElementDeclaration>();
            list.add(elDecl);
            this.uniqueNamedElements.put(en, list);
        }
        return this.uniqueNamedElements;
    }

    protected List<StartElement> getFragmentElements() throws EXIException {
        ArrayList<StartElement> fragmentElements = new ArrayList<StartElement>();
        Map<QName, List<XSElementDeclaration>> uniqueNamedElements = this.getUniqueNamedElements();
        for (Map.Entry<QName, List<XSElementDeclaration>> e : uniqueNamedElements.entrySet()) {
            StartElement se;
            QName qname = e.getKey();
            List<XSElementDeclaration> elements = e.getValue();
            assert (elements.size() >= 1);
            if (elements.size() == 1) {
                se = this.translatElementDeclarationToFSA(elements.get(0));
                fragmentElements.add(se);
                continue;
            }
            if (this.isSameElementGrammar(elements)) {
                se = this.translatElementDeclarationToFSA(elements.get(0));
                fragmentElements.add(se);
                continue;
            }
            se = this.createStartElement(qname);
            SchemaInformedGrammar elementFragmentGrammar = this.getSchemaInformedElementFragmentGrammar();
            se.setGrammar(elementFragmentGrammar);
            fragmentElements.add(se);
        }
        return fragmentElements;
    }

    protected SchemaInformedGrammar getSchemaInformedElementFragmentGrammar() throws EXIException {
        int i;
        Map<QName, List<XSElementDeclaration>> uniqueNamedElements = this.getUniqueNamedElements();
        if (this.elementFragment0 != null) {
            return this.elementFragment0;
        }
        SchemaInformedElement elementFragment1 = new SchemaInformedElement();
        this.elementFragment0 = new SchemaInformedFirstStartTag(elementFragment1);
        ArrayList<QName> uniqueNamedElementsList = new ArrayList<QName>();
        Iterator<QName> iter = uniqueNamedElements.keySet().iterator();
        while (iter.hasNext()) {
            uniqueNamedElementsList.add(iter.next());
        }
        Collections.sort(uniqueNamedElementsList, qnameSort);
        for (int i2 = 0; i2 < uniqueNamedElementsList.size(); ++i2) {
            StartElement se;
            QName fm = (QName)uniqueNamedElementsList.get(i2);
            List<XSElementDeclaration> elements = uniqueNamedElements.get(fm);
            if (elements.size() == 1 || this.isSameElementGrammar(elements)) {
                se = this.translatElementDeclarationToFSA(elements.get(0));
            } else {
                se = this.createStartElement(fm);
                se.setGrammar(this.elementFragment0);
            }
            elementFragment1.addProduction(se, elementFragment1);
        }
        elementFragment1.addProduction(START_ELEMENT_GENERIC, elementFragment1);
        elementFragment1.addTerminalProduction(END_ELEMENT);
        elementFragment1.addProduction(CHARACTERS_GENERIC, elementFragment1);
        ArrayList<QName> uniqueNamedAttributeList = new ArrayList<QName>();
        HashMap uniqueNamedAttributes = new HashMap();
        for (XSAttributeDeclaration atDecl : this.attributePool.keySet()) {
            QName atQname = new QName(atDecl.getNamespace(), atDecl.getName());
            if (uniqueNamedAttributes.containsKey(atQname)) {
                ((List)uniqueNamedAttributes.get(atQname)).add(atDecl);
                continue;
            }
            ArrayList<XSAttributeDeclaration> list = new ArrayList<XSAttributeDeclaration>();
            list.add(atDecl);
            uniqueNamedAttributes.put(atQname, list);
            uniqueNamedAttributeList.add(atQname);
        }
        XSNamedMap nm = this.xsModel.getComponents((short)1);
        for (i = 0; i < nm.getLength(); ++i) {
            XSAttributeDeclaration atDecl = (XSAttributeDeclaration)nm.item(i);
            QName atQname = new QName(atDecl.getNamespace(), atDecl.getName());
            if (uniqueNamedAttributes.containsKey(atQname)) {
                ((List)uniqueNamedAttributes.get(atQname)).add(atDecl);
                continue;
            }
            ArrayList<XSAttributeDeclaration> list = new ArrayList<XSAttributeDeclaration>();
            list.add(atDecl);
            uniqueNamedAttributes.put(atQname, list);
            uniqueNamedAttributeList.add(atQname);
        }
        Collections.sort(uniqueNamedAttributeList, qnameSort);
        for (i = 0; i < uniqueNamedAttributeList.size(); ++i) {
            QName an = (QName)uniqueNamedAttributeList.get(i);
            List attributes = (List)uniqueNamedAttributes.get(an);
            Attribute at = attributes.size() == 1 || this.isSameAttributeGrammar(attributes) ? this.getAttribute((XSAttributeDeclaration)attributes.get(0)) : this.createAttribute(an, BuiltIn.getDefaultDatatype());
            this.elementFragment0.addProduction(at, this.elementFragment0);
        }
        this.elementFragment0.addProduction(ATTRIBUTE_GENERIC, this.elementFragment0);
        for (i = 0; i < uniqueNamedElementsList.size(); ++i) {
            StartElement se;
            QName fm = (QName)uniqueNamedElementsList.get(i);
            List<XSElementDeclaration> elements = uniqueNamedElements.get(fm);
            if (elements.size() == 1 || this.isSameElementGrammar(elements)) {
                se = this.translatElementDeclarationToFSA(elements.get(0));
            } else {
                se = this.createStartElement(fm);
                se.setGrammar(this.elementFragment0);
            }
            this.elementFragment0.addProduction(se, elementFragment1);
        }
        this.elementFragment0.addProduction(START_ELEMENT_GENERIC, elementFragment1);
        this.elementFragment0.addTerminalProduction(END_ELEMENT);
        this.elementFragment0.addProduction(CHARACTERS_GENERIC, elementFragment1);
        SchemaInformedElement elementFragmentEmpty1 = new SchemaInformedElement();
        SchemaInformedFirstStartTag elementFragmentEmpty0 = new SchemaInformedFirstStartTag(elementFragmentEmpty1);
        for (int i3 = 0; i3 < uniqueNamedAttributeList.size(); ++i3) {
            QName an = (QName)uniqueNamedAttributeList.get(i3);
            List attributes = (List)uniqueNamedAttributes.get(an);
            Attribute at = attributes.size() == 1 || this.isSameAttributeGrammar(attributes) ? this.getAttribute((XSAttributeDeclaration)attributes.get(0)) : this.createAttribute(an, BuiltIn.getDefaultDatatype());
            elementFragmentEmpty0.addProduction(at, elementFragmentEmpty0);
        }
        elementFragmentEmpty0.addProduction(ATTRIBUTE_GENERIC, elementFragmentEmpty0);
        elementFragmentEmpty0.addTerminalProduction(END_ELEMENT);
        elementFragmentEmpty1.addTerminalProduction(END_ELEMENT);
        this.elementFragment0.setNillable(true);
        this.elementFragment0.setTypeEmpty(elementFragmentEmpty0);
        this.elementFragment0.setTypeCastable(true);
        return this.elementFragment0;
    }

    public SchemaInformedGrammars toGrammars() throws EXIException {
        int i;
        if (this.xsModel == null || this.schemaParsingErrors.size() > 0) {
            StringBuilder sb = new StringBuilder("Problem occured while building XML Schema Model (XSModel)!");
            for (int i2 = 0; i2 < this.schemaParsingErrors.size(); ++i2) {
                sb.append("\n. " + (String)this.schemaParsingErrors.get(i2));
            }
            throw new EXIException(sb.toString());
        }
        StringTableEntries ste = new StringTableEntries(this.xsModel);
        this.grammarUriContexts = new GrammarUriContext[ste.size()];
        int qNameID = 0;
        for (i = 0; i < ste.size(); ++i) {
            NamespaceUriEntry nsue = (NamespaceUriEntry)ste.get(i);
            String namespaceUri = nsue.namespaceUri;
            String[] prefixes = "".equals(namespaceUri) ? Constants.PREFIXES_EMPTY : ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri) ? Constants.PREFIXES_XML : ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri) ? Constants.PREFIXES_XSI : GrammarUriContext.EMPTY_PREFIXES));
            List<String> localNames = nsue.localNames;
            QNameContext[] grammarLocalNames = new QNameContext[localNames.size()];
            for (int k = 0; k < localNames.size(); ++k) {
                String localName = localNames.get(k);
                QName qname = new QName(namespaceUri, localName);
                grammarLocalNames[k] = new QNameContext(i, k, qname);
                ++qNameID;
            }
            this.grammarUriContexts[i] = new GrammarUriContext(i, namespaceUri, grammarLocalNames, prefixes);
        }
        for (i = 0; i < this.grammarUriContexts.length; ++i) {
            GrammarUriContext guc = this.grammarUriContexts[i];
            for (int k = 0; k < guc.getNumberOfQNames(); ++k) {
                XSTypeDefinition typeDef;
                XSAttributeDeclaration globalAttributeDecl;
                String namespace;
                QNameContext qnc = guc.getQNameContext(k);
                String localName = qnc.getLocalName();
                XSElementDeclaration globalElementDecl = this.xsModel.getElementDeclaration(localName, namespace = guc.getNamespaceUri());
                if (globalElementDecl != null) {
                    StartElement grammarGlobalElement = this.translatElementDeclarationToFSA(globalElementDecl);
                    qnc.setGlobalStartElement(grammarGlobalElement);
                }
                if ((globalAttributeDecl = this.xsModel.getAttributeDeclaration(localName, namespace)) != null) {
                    Attribute grammarGlobalAttribute = this.getAttribute(globalAttributeDecl);
                    qnc.setGlobalAttribute(grammarGlobalAttribute);
                }
                if ((typeDef = this.xsModel.getTypeDefinition(localName, namespace)) == null) continue;
                SchemaInformedFirstStartTagGrammar fstr = this.translateTypeDefinitionToFSA(typeDef);
                qnc.setTypeGrammar(fstr);
            }
        }
        List<StartElement> globalElements = this.initGrammars();
        List<StartElement> fragmentElements = this.getFragmentElements();
        Collections.sort(globalElements, startElementSort);
        Collections.sort(fragmentElements, startElementSort);
        DocEnd builtInDocEndGrammar = new DocEnd("DocEnd");
        builtInDocEndGrammar.addTerminalProduction(new EndDocument());
        SchemaInformedDocContent builtInDocContentGrammar = new SchemaInformedDocContent("DocContent");
        builtInDocContentGrammar.addProduction(START_ELEMENT_GENERIC, builtInDocEndGrammar);
        for (int i3 = 0; i3 < globalElements.size(); ++i3) {
            StartElement globalElement = globalElements.get(i3);
            builtInDocContentGrammar.addProduction(globalElement, builtInDocEndGrammar);
        }
        Document documentGrammar = new Document("Document");
        documentGrammar.addProduction(new StartDocument(), builtInDocContentGrammar);
        SchemaInformedFragmentContent builtInFragmentContentGrammar = new SchemaInformedFragmentContent("FragmentContent");
        builtInFragmentContentGrammar.addProduction(START_ELEMENT_GENERIC, builtInFragmentContentGrammar);
        builtInFragmentContentGrammar.addTerminalProduction(new EndDocument());
        for (int i4 = 0; i4 < fragmentElements.size(); ++i4) {
            StartElement fragmentElement = fragmentElements.get(i4);
            builtInFragmentContentGrammar.addProduction(fragmentElement, builtInFragmentContentGrammar);
        }
        Fragment fragmentGrammar = new Fragment("Fragment");
        fragmentGrammar.addProduction(new StartDocument(), builtInFragmentContentGrammar);
        GrammarContext grammarContext = new GrammarContext(this.grammarUriContexts, qNameID);
        SchemaInformedGrammars sig = new SchemaInformedGrammars(grammarContext, documentGrammar, fragmentGrammar, this.getSchemaInformedElementFragmentGrammar());
        return sig;
    }

    protected static boolean isAdditionalNamespace(String namespaceURI) {
        assert (namespaceURI != null);
        return !namespaceURI.equals("") && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace") && !namespaceURI.equals("http://www.w3.org/2001/XMLSchema-instance") && !namespaceURI.equals("http://www.w3.org/2001/XMLSchema");
    }

    protected String[] getURITableEntries() {
        StringList namespaces = this.xsModel.getNamespaces();
        TreeSet<String> sortedURIs = new TreeSet<String>();
        for (int i = 0; i < namespaces.getLength(); ++i) {
            String uri;
            String string = uri = namespaces.item(i) == null ? "" : namespaces.item(i);
            if (!XSDGrammarsBuilder.isAdditionalNamespace(uri)) continue;
            sortedURIs.add(uri);
        }
        for (String uri : this.schemaLocalNames.keySet()) {
            if (!XSDGrammarsBuilder.isAdditionalNamespace(uri)) continue;
            sortedURIs.add(uri);
        }
        String[] uris = new String[4 + sortedURIs.size()];
        uris[0] = "";
        uris[1] = "http://www.w3.org/XML/1998/namespace";
        uris[2] = "http://www.w3.org/2001/XMLSchema-instance";
        uris[3] = "http://www.w3.org/2001/XMLSchema";
        int compactID = 4;
        Iterator iterator = sortedURIs.iterator();
        while (iterator.hasNext()) {
            String addUri;
            uris[compactID] = addUri = (String)iterator.next();
            ++compactID;
        }
        return uris;
    }

    @Override
    protected void addLocalNameStringEntry(String namespaceURI, String localName) {
        List<String> localNameList = this.addNamespaceStringEntry(namespaceURI);
        if (!localNameList.contains(localName)) {
            localNameList.add(localName);
        }
    }

    @Override
    protected List<String> addNamespaceStringEntry(String namespaceURI) {
        ArrayList<String> localNameList;
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (this.schemaLocalNames.containsKey(namespaceURI)) {
            localNameList = this.schemaLocalNames.get(namespaceURI);
        } else {
            localNameList = new ArrayList();
            this.schemaLocalNames.put(namespaceURI, localNameList);
        }
        return localNameList;
    }

    protected List<StartElement> initGrammars() throws EXIException {
        ArrayList<StartElement> globalElements = new ArrayList<StartElement>();
        XSNamedMap types = this.xsModel.getComponents((short)3);
        for (int i = 0; i < types.getLength(); ++i) {
            XSTypeDefinition td = (XSTypeDefinition)types.item(i);
            SchemaInformedFirstStartTagGrammar sir = this.translateTypeDefinitionToFSA(td);
            assert (!sir.isNillable());
            assert (!sir.isTypeCastable());
        }
        XSNamedMap xsGlobalElements = this.xsModel.getComponents((short)2);
        for (int i = 0; i < xsGlobalElements.getLength(); ++i) {
            XSElementDeclaration globalElementDecl = (XSElementDeclaration)xsGlobalElements.item(i);
            StartElement seGlobalElement = this.translatElementDeclarationToFSA(globalElementDecl);
            globalElements.add(seGlobalElement);
        }
        return globalElements;
    }

    protected Attribute getAttribute(XSAttributeDeclaration attrDecl) throws EXIException {
        Attribute at;
        this.addLocalNameStringEntry(attrDecl.getNamespace(), attrDecl.getName());
        if (this.attributePool.containsKey(attrDecl)) {
            at = this.attributePool.get(attrDecl);
        } else {
            XSSimpleTypeDefinition std = attrDecl.getTypeDefinition();
            QName qname = new QName(attrDecl.getNamespace(), attrDecl.getName());
            at = this.createAttribute(qname, this.getDatatype(std));
            this.attributePool.put(attrDecl, at);
        }
        return at;
    }

    protected XSTypeDefinition getBaseType(XSTypeDefinition td) {
        if (td.getTypeCategory() == 16) {
            if ("negativeInteger".equals(td.getName()) && "http://www.w3.org/2001/XMLSchema".equals(td.getNamespace())) {
                XSTypeDefinition td2 = this.xsModel.getTypeDefinition("nonPositiveInteger", "http://www.w3.org/2001/XMLSchema");
                return td2;
            }
            return td.getBaseType();
        }
        return td.getBaseType();
    }

    protected QName getValueType(XSTypeDefinition typeDefinition) {
        while (typeDefinition.getAnonymous()) {
            typeDefinition = this.getBaseType(typeDefinition);
        }
        QName valueType = new QName(typeDefinition.getNamespace(), typeDefinition.getName());
        return valueType;
    }

    protected SchemaInformedStartTagGrammar handleAttributes(SchemaInformedGrammar ruleContent, SchemaInformedGrammar ruleContent2, XSObjectList attributes, XSWildcard attributeWC) throws EXIException {
        SchemaInformedStartTag ruleStart = new SchemaInformedStartTag(ruleContent2);
        for (int i = 0; i < ruleContent.getNumberOfEvents(); ++i) {
            Production ei = ruleContent.getProduction(i);
            ruleStart.addProduction(ei.getEvent(), ei.getNextGrammar());
        }
        if (attributeWC != null) {
            this.handleAttributeWildCard(attributeWC, ruleStart);
        }
        if (attributes != null && attributes.getLength() > 0) {
            XSAttributeUse attrUse;
            int i;
            ArrayList<XSAttributeUse> vSortedAttributes = new ArrayList<XSAttributeUse>();
            for (i = 0; i < attributes.getLength(); ++i) {
                assert (attributes.item(i).getType() == 4);
                attrUse = (XSAttributeUse)attributes.item(i);
                vSortedAttributes.add(attrUse);
            }
            Collections.sort(vSortedAttributes, attributeUseSort);
            for (i = vSortedAttributes.size() - 1; i >= 0; --i) {
                attrUse = (XSAttributeUse)vSortedAttributes.get(i);
                Attribute at = this.getAttribute(attrUse.getAttrDeclaration());
                SchemaInformedStartTag newCurrent = new SchemaInformedStartTag(ruleContent2);
                newCurrent.addProduction(at, ruleStart);
                if (attributeWC != null) {
                    this.handleAttributeWildCard(attributeWC, newCurrent);
                }
                if (!attrUse.getRequired()) {
                    for (int k = 0; k < ruleStart.getNumberOfEvents(); ++k) {
                        Production ei = ruleStart.getProduction(k);
                        if (ei.getEvent().isEventType(EventType.ATTRIBUTE_GENERIC) || ei.getEvent().isEventType(EventType.ATTRIBUTE_NS)) continue;
                        newCurrent.addProduction(ei.getEvent(), ei.getNextGrammar());
                    }
                }
                ruleStart = newCurrent;
            }
        }
        return ruleStart;
    }

    protected void handleAttributeWildCard(XSWildcard attributeWC, SchemaInformedGrammar rule) {
        short constraintType = attributeWC.getConstraintType();
        if (constraintType == 1 || constraintType == 2) {
            rule.addProduction(ATTRIBUTE_GENERIC, rule);
        } else {
            StringList sl = attributeWC.getNsConstraintList();
            for (int k = 0; k < sl.getLength(); ++k) {
                String namespace = sl.item(k);
                rule.addProduction(this.createAttributeNS(namespace), rule);
                this.addNamespaceStringEntry(namespace);
            }
        }
    }

    protected SchemaInformedFirstStartTagGrammar getTypeGrammar(String namespaceURI, String name) {
        QName en = new QName(namespaceURI, name);
        return this.grammarTypes.get(en);
    }

    @Override
    protected StartElement translatElementDeclarationToFSA(XSElementDeclaration xsElementDeclaration) throws EXIException {
        StartElement se = null;
        if (this.elementPool.containsKey(xsElementDeclaration)) {
            return (StartElement)this.elementPool.get(xsElementDeclaration);
        }
        String namespaceURI = xsElementDeclaration.getNamespace();
        String localName = xsElementDeclaration.getName();
        QName qname = new QName(namespaceURI, localName);
        se = this.createStartElement(qname);
        this.addLocalNameStringEntry(namespaceURI, localName);
        this.elementPool.put(xsElementDeclaration, se);
        this.addLocalNameStringEntry(xsElementDeclaration.getNamespace(), xsElementDeclaration.getName());
        XSTypeDefinition td = xsElementDeclaration.getTypeDefinition();
        SchemaInformedFirstStartTagGrammar type = this.translateTypeDefinitionToFSA(td);
        if (type.isNillable() || type.isTypeCastable()) {
            throw new RuntimeException("Type grammar is nillable or typable, " + type + "\t" + td);
        }
        if (td.getAnonymous()) {
            type.setNillable(xsElementDeclaration.getNillable());
            type.setTypeCastable(this.isTypeCastable(td));
            se.setGrammar(type);
        } else if (xsElementDeclaration.getNillable() || this.isTypeCastable(td)) {
            SchemaInformedFirstStartTagGrammar element = (SchemaInformedFirstStartTagGrammar)type.duplicate();
            element.setNillable(xsElementDeclaration.getNillable());
            element.setTypeCastable(this.isTypeCastable(td));
            se.setGrammar(element);
        } else {
            se.setGrammar(type);
        }
        return se;
    }

    protected boolean isTypeCastable(XSTypeDefinition td) {
        boolean isTypeCastable = false;
        XSNamedMap types = this.xsModel.getComponents((short)3);
        for (int i = 0; i < types.getLength(); ++i) {
            XSTypeDefinition td2 = (XSTypeDefinition)types.item(i);
            if (!td.equals(this.getBaseType(td2))) continue;
            isTypeCastable = true;
        }
        if (!isTypeCastable && td.getTypeCategory() == 16) {
            XSSimpleTypeDefinition std = (XSSimpleTypeDefinition)td;
            isTypeCastable = std.getVariety() == 3;
        }
        return isTypeCastable;
    }

    protected SchemaInformedFirstStartTagGrammar translateTypeDefinitionToFSA(XSTypeDefinition td) throws EXIException {
        SchemaInformedFirstStartTagGrammar type_i = null;
        QName typeName = null;
        if (!td.getAnonymous() && (type_i = this.grammarTypes.get(typeName = new QName(td.getNamespace(), td.getName()))) != null) {
            return type_i;
        }
        if (td.getTypeCategory() == 15) {
            XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)td;
            type_i = this.translateComplexTypeDefinitionToFSA(ctd);
        } else {
            assert (td.getTypeCategory() == 16);
            XSSimpleTypeDefinition std = (XSSimpleTypeDefinition)td;
            type_i = this.translateSimpleTypeDefinitionToFSA(std);
        }
        if (!td.getAnonymous()) {
            this.addLocalNameStringEntry(td.getNamespace(), td.getName());
            this.grammarTypes.put(typeName, type_i);
        }
        return type_i;
    }

    protected SchemaInformedFirstStartTagGrammar translateComplexTypeDefinitionToFSA(XSComplexTypeDefinition ctd) throws EXIException {
        SchemaInformedGrammar ruleContent = null;
        switch (ctd.getContentType()) {
            case 0: {
                ruleContent = new SchemaInformedElement();
                ruleContent.addTerminalProduction(END_ELEMENT);
                break;
            }
            case 1: {
                XSSimpleTypeDefinition std = ctd.getSimpleType();
                ruleContent = this.translateSimpleTypeDefinitionToFSA(std);
                break;
            }
            case 2: {
                boolean isMixedContent = false;
                ruleContent = this.handleParticle(ctd, isMixedContent);
                break;
            }
            default: {
                assert (ctd.getContentType() == 3);
                boolean isMixedContent = true;
                ruleContent = this.handleParticle(ctd, isMixedContent);
            }
        }
        SchemaInformedGrammar ruleContent2 = ruleContent.duplicate();
        if (ruleContent2 instanceof SchemaInformedStartTagGrammar) {
            SchemaInformedElement sie = new SchemaInformedElement();
            for (int i = 0; i < ruleContent2.getNumberOfEvents(); ++i) {
                Production p = ruleContent2.getProduction(i);
                sie.addProduction(p.getEvent(), p.getNextGrammar());
            }
            ruleContent2 = sie;
        }
        XSObjectList attributes = ctd.getAttributeUses();
        XSWildcard attributeWC = ctd.getAttributeWildcard();
        SchemaInformedStartTagGrammar sistr = this.handleAttributes(ruleContent, ruleContent2, attributes, attributeWC);
        SchemaInformedFirstStartTag type_i = new SchemaInformedFirstStartTag(sistr);
        SchemaInformedElement ruleEnd = new SchemaInformedElement();
        ruleEnd.addTerminalProduction(END_ELEMENT);
        SchemaInformedFirstStartTag typeEmpty_i = new SchemaInformedFirstStartTag(this.handleAttributes(ruleEnd, ruleEnd, attributes, attributeWC));
        type_i.setTypeEmpty(typeEmpty_i);
        return type_i;
    }

    protected SchemaInformedFirstStartTagGrammar translateSimpleTypeDefinitionToFSA(XSSimpleTypeDefinition std) throws EXIException {
        Characters chSchemaValid = new Characters(this.getDatatype(std));
        SchemaInformedGrammar simpleContentEnd = this.SIMPLE_END_ELEMENT_RULE;
        SchemaInformedElement simpleContent = new SchemaInformedElement();
        simpleContent.addProduction(chSchemaValid, simpleContentEnd);
        SchemaInformedFirstStartTag type_i = new SchemaInformedFirstStartTag(this.handleAttributes(simpleContent, simpleContent, null, null));
        type_i.setTypeEmpty(this.SIMPLE_END_ELEMENT_EMPTY_RULE);
        return type_i;
    }

    public Datatype getDatatype(XSSimpleTypeDefinition std) throws EXIException {
        XSObjectList anns;
        Datatype datatype = this.datatypePool.get(std);
        if (datatype != null) {
            return datatype;
        }
        QName schemaType = this.getSchemaType(std);
        QNameContext qncSchemaType = XSDGrammarsBuilder.getQNameContext(schemaType.getNamespaceURI(), schemaType.getLocalPart(), this.grammarUriContexts);
        if (std.isDefinedFacet((short)2048)) {
            XSObjectList facetList = std.getMultiValueFacets();
            for (int i = 0; i < facetList.getLength(); ++i) {
                XSMultiValueFacet enumer;
                XSObject facet = facetList.item(i);
                if (facet.getType() != 14 || (enumer = (XSMultiValueFacet)facet).getFacetKind() != 2048) continue;
                StringList enumList = enumer.getLexicalFacetValues();
                XSSimpleTypeDefinition stdEnum = (XSSimpleTypeDefinition)std.getBaseType();
                while (this.getDatatype(stdEnum).getBuiltInType() == BuiltInType.ENUMERATION) {
                    stdEnum = (XSSimpleTypeDefinition)stdEnum.getBaseType();
                }
                if (stdEnum.getVariety() == 3) {
                    datatype = new StringDatatype(qncSchemaType, true);
                    continue;
                }
                if (BuiltIn.XSD_QNAME.equals(this.getSchemaType(stdEnum)) || BuiltIn.XSD_NOTATION.equals(this.getSchemaType(stdEnum))) {
                    datatype = new StringDatatype(qncSchemaType, this.getWhiteSpaceFacet(stdEnum));
                    continue;
                }
                Datatype dtEnumValues = this.getDatatype(stdEnum);
                Value[] values = new Value[enumList.getLength()];
                BuiltInType enumBIT = dtEnumValues.getBuiltInType();
                if (enumBIT == BuiltInType.LIST) {
                    ListDatatype listDT = (ListDatatype)dtEnumValues;
                    Datatype dtL = listDT.getListDatatype();
                    datatype = new ListDatatype(dtL, qncSchemaType);
                    continue;
                }
                for (int k = 0; k < enumList.getLength(); ++k) {
                    AbstractValue enumValue;
                    String tok = enumList.item(k);
                    switch (enumBIT) {
                        case BINARY_BASE64: {
                            enumValue = BinaryBase64Value.parse(tok);
                            break;
                        }
                        case BINARY_HEX: {
                            enumValue = BinaryHexValue.parse(tok);
                            break;
                        }
                        case BOOLEAN: {
                            enumValue = BooleanValue.parse(tok);
                            break;
                        }
                        case DECIMAL: {
                            enumValue = DecimalValue.parse(tok);
                            break;
                        }
                        case FLOAT: {
                            enumValue = FloatValue.parse(tok);
                            break;
                        }
                        case NBIT_UNSIGNED_INTEGER: 
                        case UNSIGNED_INTEGER: 
                        case INTEGER: {
                            enumValue = IntegerValue.parse(tok);
                            break;
                        }
                        case DATETIME: {
                            DatetimeDatatype datetimeDT = (DatetimeDatatype)dtEnumValues;
                            enumValue = DateTimeValue.parse(tok, datetimeDT.getDatetimeType());
                            break;
                        }
                        case LIST: {
                            throw new RuntimeException("Enumerated values not possible as part of a list");
                        }
                        default: {
                            enumValue = new StringValue(tok);
                            enumBIT = BuiltInType.STRING;
                        }
                    }
                    if (enumValue == null) {
                        throw new RuntimeException("Enum value cannot be parsed properly, " + enumValue + "', " + stdEnum);
                    }
                    TypedTypeEncoder typeEncoder = new TypedTypeEncoder();
                    boolean valid = typeEncoder.isValid(dtEnumValues, enumValue);
                    if (!valid) {
                        throw new RuntimeException("No valid enumeration value '" + enumValue + "', " + stdEnum);
                    }
                    values[k] = enumValue;
                }
                datatype = new EnumerationDatatype(values, dtEnumValues, qncSchemaType);
            }
        } else if (std.getVariety() == 2) {
            XSSimpleTypeDefinition listSTD = std.getItemType();
            Datatype dtList = this.getDatatype(listSTD);
            datatype = new ListDatatype(dtList, qncSchemaType);
        } else {
            datatype = std.getVariety() == 3 ? new StringDatatype(qncSchemaType, true) : this.getDatatypeOfType(std, schemaType);
        }
        XSTypeDefinition baseType = this.getBaseType(std);
        if (baseType != null && baseType.getTypeCategory() == 16) {
            XSSimpleTypeDefinition stdBaseType = (XSSimpleTypeDefinition)baseType;
            datatype.setBaseDatatype(this.getDatatype(stdBaseType));
        }
        if ((anns = std.getAnnotations()) != null && anns.getLength() > 0) {
            try {
                for (int i = 0; i < anns.getLength(); ++i) {
                    XSAnnotation ann = (XSAnnotation)anns.get(i);
                    String as = ann.getAnnotationString();
                    XMLReader reader = XMLReaderFactory.createXMLReader();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    String enumTypeName = "grammarEnumerationType";
                    GrammarAnnotationFilter xmlS = new GrammarAnnotationFilter(baos, enumTypeName);
                    reader.setContentHandler(xmlS);
                    reader.parse(new InputSource(new ByteArrayInputStream(as.getBytes())));
                    Grammars grs = GrammarFactory.newInstance().createGrammars(new ByteArrayInputStream(baos.toByteArray()));
                    SchemaInformedFirstStartTagGrammar tg = grs.getGrammarContext().getGrammarUriContext("").getQNameContext(enumTypeName).getTypeGrammar();
                    Event ev = tg.getProduction(0).getEvent();
                    DatatypeEvent dev = (DatatypeEvent)ev;
                    Datatype dt = dev.getDatatype();
                    if (dt.getBuiltInType() != BuiltInType.ENUMERATION) continue;
                    EnumerationDatatype edt = (EnumerationDatatype)dt;
                    datatype.setGrammarEnumeration(edt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.datatypePool.put(std, datatype);
        return datatype;
    }

    private QName getXMLSchemaDatatype(XSSimpleTypeDefinition std) {
        QName exiDatatypeID;
        QName primitive = this.getPrimitive(std);
        if (primitive.equals(BuiltIn.XSD_DECIMAL)) {
            XSTypeDefinition xmlSchemaType;
            for (xmlSchemaType = std; xmlSchemaType != null && (xmlSchemaType.getName() == null || !BuiltIn.XSD_INTEGER.equals(this.getName(xmlSchemaType)) && !BuiltIn.XSD_NON_NEGATIVE_INTEGER.equals(this.getName(xmlSchemaType))); xmlSchemaType = xmlSchemaType.getBaseType()) {
            }
            exiDatatypeID = xmlSchemaType == null ? BuiltIn.XSD_DECIMAL : BuiltIn.XSD_INTEGER;
        } else {
            exiDatatypeID = this.getBuiltInOfPrimitiveMapping(primitive);
        }
        return exiDatatypeID;
    }

    private QName getSchemaType(XSSimpleTypeDefinition std) {
        String name;
        String uri;
        if (std.getAnonymous()) {
            XSTypeDefinition baseType = std;
            while ((baseType = baseType.getBaseType()).getAnonymous()) {
            }
            uri = baseType.getNamespace();
            name = baseType.getName();
        } else {
            uri = std.getNamespace();
            name = std.getName();
        }
        return new QName(uri, name);
    }

    private Datatype getIntegerDatatype(XSSimpleTypeDefinition std, QName schemaType) {
        AbstractDatatype datatype;
        block43: {
            IntegerType intType;
            QNameContext qncSchemaType;
            block44: {
                BigInteger min;
                block42: {
                    qncSchemaType = XSDGrammarsBuilder.getQNameContext(schemaType.getNamespaceURI(), schemaType.getLocalPart(), this.grammarUriContexts);
                    XSTypeDefinition xsdSTD = std;
                    while (!"http://www.w3.org/2001/XMLSchema".equals(xsdSTD.getNamespace())) {
                        xsdSTD = xsdSTD.getBaseType();
                    }
                    if (xsdSTD.getName().equals("integer") || xsdSTD.getName().equals("nonPositiveInteger") || xsdSTD.getName().equals("negativeInteger")) {
                        intType = IntegerType.INTEGER_BIG;
                    } else if (xsdSTD.getName().equals("nonNegativeInteger") || xsdSTD.getName().equals("positiveInteger")) {
                        intType = IntegerType.UNSIGNED_INTEGER_BIG;
                    } else if (xsdSTD.getName().equals("long")) {
                        intType = IntegerType.INTEGER_64;
                    } else if (xsdSTD.getName().equals("unsignedLong")) {
                        intType = IntegerType.UNSIGNED_INTEGER_64;
                    } else if (xsdSTD.getName().equals("int")) {
                        intType = IntegerType.INTEGER_32;
                    } else if (xsdSTD.getName().equals("unsignedInt")) {
                        intType = IntegerType.UNSIGNED_INTEGER_32;
                    } else if (xsdSTD.getName().equals("short")) {
                        intType = IntegerType.INTEGER_16;
                    } else if (xsdSTD.getName().equals("unsignedShort")) {
                        intType = IntegerType.UNSIGNED_INTEGER_16;
                    } else if (xsdSTD.getName().equals("byte")) {
                        intType = IntegerType.INTEGER_8;
                    } else if (xsdSTD.getName().equals("unsignedByte")) {
                        intType = IntegerType.UNSIGNED_INTEGER_8;
                    } else {
                        throw new RuntimeException("Unexpected Integer Type: " + xsdSTD);
                    }
                    min = new BigInteger("-9999999999999999999999999999999999999999");
                    BigInteger max = new BigInteger("9999999999999999999999999999999999999999");
                    if (std.isDefinedFacet((short)256)) {
                        String sMinInclusive = std.getLexicalFacetValue((short)256);
                        min = min.max(new BigInteger(sMinInclusive));
                    }
                    if (std.isDefinedFacet((short)128)) {
                        String sMinExclusive = std.getLexicalFacetValue((short)128);
                        min = min.max(new BigInteger(sMinExclusive).add(BigInteger.ONE));
                    }
                    if (std.isDefinedFacet((short)32)) {
                        String sMaxInclusive = std.getLexicalFacetValue((short)32);
                        max = max.min(new BigInteger(sMaxInclusive));
                    }
                    if (std.isDefinedFacet((short)64)) {
                        String sMaxExclusive = std.getLexicalFacetValue((short)64);
                        max = max.min(new BigInteger(sMaxExclusive).subtract(BigInteger.ONE));
                    }
                    assert (max.compareTo(min) >= 0);
                    BigInteger boundedRange = max.subtract(min).add(BigInteger.ONE);
                    if (boundedRange.compareTo(BigInteger.valueOf(4096L)) > 0) break block42;
                    switch (intType) {
                        case UNSIGNED_INTEGER_BIG: 
                        case UNSIGNED_INTEGER_64: 
                        case UNSIGNED_INTEGER_32: 
                        case UNSIGNED_INTEGER_16: 
                        case UNSIGNED_INTEGER_8: 
                        case INTEGER_BIG: 
                        case INTEGER_64: 
                        case INTEGER_32: 
                        case INTEGER_16: 
                        case INTEGER_8: {
                            datatype = new NBitUnsignedIntegerDatatype(IntegerValue.valueOf(min), IntegerValue.valueOf(max), qncSchemaType);
                            break block43;
                        }
                        default: {
                            throw new RuntimeException("Unexpected n-Bit Integer Type: " + (Object)((Object)intType));
                        }
                    }
                }
                if (min.signum() < 0) break block44;
                switch (intType) {
                    case INTEGER_BIG: {
                        intType = IntegerType.UNSIGNED_INTEGER_BIG;
                        break;
                    }
                    case INTEGER_64: {
                        intType = IntegerType.UNSIGNED_INTEGER_64;
                        break;
                    }
                    case INTEGER_32: {
                        intType = IntegerType.UNSIGNED_INTEGER_32;
                        break;
                    }
                    case INTEGER_16: {
                        intType = IntegerType.UNSIGNED_INTEGER_16;
                        break;
                    }
                    case INTEGER_8: {
                        intType = IntegerType.UNSIGNED_INTEGER_8;
                        break;
                    }
                }
                switch (intType) {
                    case UNSIGNED_INTEGER_BIG: 
                    case UNSIGNED_INTEGER_64: 
                    case UNSIGNED_INTEGER_32: 
                    case UNSIGNED_INTEGER_16: 
                    case UNSIGNED_INTEGER_8: {
                        datatype = new UnsignedIntegerDatatype(qncSchemaType);
                        break block43;
                    }
                    default: {
                        throw new RuntimeException("Unexpected Unsigned Integer Type: " + (Object)((Object)intType));
                    }
                }
            }
            switch (intType) {
                case INTEGER_BIG: 
                case INTEGER_64: 
                case INTEGER_32: 
                case INTEGER_16: 
                case INTEGER_8: {
                    datatype = new IntegerDatatype(qncSchemaType);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected Integer Type: " + (Object)((Object)intType));
                }
            }
        }
        return datatype;
    }

    private QName getName(XSTypeDefinition type) {
        return new QName(type.getNamespace(), type.getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Datatype getDatatypeOfType(XSSimpleTypeDefinition std, QName schemaType) {
        void var4_26;
        QNameContext qncSchemaType = XSDGrammarsBuilder.getQNameContext(schemaType.getNamespaceURI(), schemaType.getLocalPart(), this.grammarUriContexts);
        QName schemaDatatype = this.getXMLSchemaDatatype(std);
        if (BuiltIn.XSD_BASE64BINARY.equals(schemaDatatype)) {
            BinaryBase64Datatype binaryBase64Datatype = new BinaryBase64Datatype(qncSchemaType);
            return var4_26;
        } else if (BuiltIn.XSD_HEXBINARY.equals(schemaDatatype)) {
            BinaryHexDatatype binaryHexDatatype = new BinaryHexDatatype(qncSchemaType);
            return var4_26;
        } else if (BuiltIn.XSD_BOOLEAN.equals(schemaDatatype)) {
            if (std.isDefinedFacet((short)8)) {
                BooleanFacetDatatype booleanFacetDatatype = new BooleanFacetDatatype(qncSchemaType);
                return var4_26;
            } else {
                BooleanDatatype booleanDatatype = new BooleanDatatype(qncSchemaType);
            }
            return var4_26;
        } else if (BuiltIn.XSD_DATETIME.equals(schemaDatatype)) {
            QName primitive = this.getPrimitive(std);
            if (BuiltIn.XSD_DATETIME.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.dateTime, qncSchemaType);
                return var4_26;
            } else if (BuiltIn.XSD_TIME.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.time, qncSchemaType);
                return var4_26;
            } else if (BuiltIn.XSD_DATE.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.date, qncSchemaType);
                return var4_26;
            } else if (BuiltIn.XSD_GYEARMONTH.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gYearMonth, qncSchemaType);
                return var4_26;
            } else if (BuiltIn.XSD_GYEAR.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gYear, qncSchemaType);
                return var4_26;
            } else if (BuiltIn.XSD_GMONTHDAY.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonthDay, qncSchemaType);
                return var4_26;
            } else if (BuiltIn.XSD_GDAY.equals(primitive)) {
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gDay, qncSchemaType);
                return var4_26;
            } else {
                if (!BuiltIn.XSD_GMONTH.equals(primitive)) throw new RuntimeException();
                DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonth, qncSchemaType);
            }
            return var4_26;
        } else if (BuiltIn.XSD_DECIMAL.equals(schemaDatatype)) {
            DecimalDatatype decimalDatatype = new DecimalDatatype(qncSchemaType);
            return var4_26;
        } else if (BuiltIn.XSD_FLOAT.equals(schemaDatatype) || BuiltIn.XSD_DOUBLE.equals(schemaDatatype)) {
            FloatDatatype floatDatatype = new FloatDatatype(qncSchemaType);
            return var4_26;
        } else if (BuiltIn.XSD_INTEGER.equals(schemaDatatype)) {
            Datatype datatype = this.getIntegerDatatype(std, schemaType);
            return var4_26;
        } else if (std.isDefinedFacet((short)8)) {
            StringList sl = std.getLexicalPattern();
            if (this.isBuiltInTypeFacet(std, sl.getLength())) {
                StringDatatype stringDatatype = new StringDatatype(qncSchemaType, this.getWhiteSpaceFacet(std));
                return var4_26;
            } else {
                String regexPattern = sl.item(0);
                EXIRegularExpression re = new EXIRegularExpression(regexPattern);
                if (re.isEntireSetOfXMLCharacters()) {
                    StringDatatype stringDatatype = new StringDatatype(qncSchemaType, this.getWhiteSpaceFacet(std));
                    return var4_26;
                } else {
                    CodePointCharacterSet rcs = new CodePointCharacterSet(re.getCodePoints());
                    RestrictedCharacterSetDatatype restrictedCharacterSetDatatype = new RestrictedCharacterSetDatatype(rcs, qncSchemaType, this.getWhiteSpaceFacet(std));
                }
            }
            return var4_26;
        } else {
            StringDatatype stringDatatype = new StringDatatype(qncSchemaType, this.getWhiteSpaceFacet(std));
        }
        return var4_26;
    }

    private WhiteSpace getWhiteSpaceFacet(XSSimpleTypeDefinition std) {
        WhiteSpace whiteSpace = WhiteSpace.preserve;
        boolean hasWSF = std.isDefinedFacet((short)16);
        if (hasWSF) {
            XSObject o = std.getFacet(16);
            XSFacet fac = (XSFacet)o;
            String fv = fac.getLexicalFacetValue();
            if ("preserve".equals(fv)) {
                whiteSpace = WhiteSpace.preserve;
            } else if ("replace".equals(fv)) {
                whiteSpace = WhiteSpace.replace;
            } else if ("collapse".equals(fv)) {
                whiteSpace = WhiteSpace.collapse;
            } else {
                throw new RuntimeException("Unexpected WhiteSpace facet value: " + fv);
            }
        }
        return whiteSpace;
    }

    private boolean isBuiltInTypeFacet(XSSimpleTypeDefinition std, int patternListLength) {
        XSSimpleTypeDefinition baseType = (XSSimpleTypeDefinition)std.getBaseType();
        boolean isBuiltInTypeFacet = baseType == null || !baseType.isDefinedFacet((short)8) ? "http://www.w3.org/2001/XMLSchema".equals(std.getNamespace()) : (baseType.getLexicalPattern().getLength() < patternListLength ? "http://www.w3.org/2001/XMLSchema".equals(std.getNamespace()) : this.isBuiltInTypeFacet(baseType, patternListLength));
        return isBuiltInTypeFacet;
    }

    private QName getPrimitive(XSSimpleTypeDefinition std) {
        XSSimpleTypeDefinition primitiveType = std.getPrimitiveType();
        QName primitiveQName = primitiveType == null ? BuiltIn.XSD_ANY_SIMPLE_TYPE : new QName(primitiveType.getNamespace(), primitiveType.getName());
        return primitiveQName;
    }

    private QName getBuiltInOfPrimitiveMapping(QName qnamePrimitive) {
        if (this.datatypeMapping.containsKey(qnamePrimitive)) {
            return this.datatypeMapping.get(qnamePrimitive);
        }
        return BuiltIn.DEFAULT_VALUE_NAME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringTableEntries
    extends ArrayList<NamespaceUriEntry> {
        private static final long serialVersionUID = 1L;
        private final XSModel xsModel;
        Set<XSComplexTypeDefinition> cTypes = new HashSet<XSComplexTypeDefinition>();

        public StringTableEntries(XSModel xsModel) {
            this.xsModel = xsModel;
            this.add(new NamespaceUriEntry(""));
            NamespaceUriEntry nsue1 = new NamespaceUriEntry("http://www.w3.org/XML/1998/namespace");
            nsue1.localNames.add("base");
            nsue1.localNames.add("id");
            nsue1.localNames.add("lang");
            nsue1.localNames.add("space");
            this.add(nsue1);
            NamespaceUriEntry nsue2 = new NamespaceUriEntry("http://www.w3.org/2001/XMLSchema-instance");
            nsue2.localNames.add("nil");
            nsue2.localNames.add("type");
            this.add(nsue2);
            this.add(new NamespaceUriEntry("http://www.w3.org/2001/XMLSchema"));
            this.initializeEntries();
            Collections.sort(this);
            for (int i = 0; i < this.size(); ++i) {
                NamespaceUriEntry nsue = (NamespaceUriEntry)this.get(i);
                Collections.sort(nsue.localNames);
            }
        }

        private void initializeEntries() {
            XSObject it;
            int k;
            StringList nss = this.xsModel.getNamespaces();
            for (int i = 0; i < nss.size(); ++i) {
                String ns = (String)nss.get(i);
                this.checkNamespaceUriEntry(ns);
            }
            XSNamedMap nm = this.xsModel.getComponents((short)16);
            for (k = 0; k < nm.size(); ++k) {
                XSSimpleTypeDefinition std = (XSSimpleTypeDefinition)nm.item(k);
                this.handleSimpleType(std);
            }
            nm = this.xsModel.getComponents((short)15);
            for (k = 0; k < nm.size(); ++k) {
                XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)nm.item(k);
                this.handleComplexType(ctd);
            }
            nm = this.xsModel.getComponents((short)2);
            for (k = 0; k < nm.size(); ++k) {
                it = (XSElementDeclaration)nm.item(k);
                this.handleElementDeclaration((XSElementDeclaration)it);
            }
            nm = this.xsModel.getComponents((short)1);
            for (k = 0; k < nm.size(); ++k) {
                it = (XSAttributeDeclaration)nm.item(k);
                this.handleAttributeDeclaration((XSAttributeDeclaration)it);
            }
        }

        private NamespaceUriEntry checkNamespaceUriEntry(String namespaceUri) {
            namespaceUri = namespaceUri == null ? "" : namespaceUri;
            for (int i = 0; i < this.size(); ++i) {
                NamespaceUriEntry nsue = (NamespaceUriEntry)this.get(i);
                if (!nsue.namespaceUri.equals(namespaceUri)) continue;
                return nsue;
            }
            NamespaceUriEntry nsue = new NamespaceUriEntry(namespaceUri);
            this.add(nsue);
            return nsue;
        }

        private void checkEntry(String namespaceUri, String localName) {
            NamespaceUriEntry nsue = this.checkNamespaceUriEntry(namespaceUri);
            assert (localName != null);
            if (!nsue.localNames.contains(localName)) {
                nsue.localNames.add(localName);
            }
        }

        private void handleAttributeDeclaration(XSAttributeDeclaration ad) {
            this.checkEntry(ad.getNamespace(), ad.getName());
            this.handleType(ad.getTypeDefinition());
        }

        private void handleElementDeclaration(XSElementDeclaration ed) {
            XSObjectList subs;
            this.checkEntry(ed.getNamespace(), ed.getName());
            this.handleType(ed.getTypeDefinition());
            XSNamedMap globalElements = this.xsModel.getComponents((short)2);
            if (globalElements != null && globalElements.size() > 0 && (subs = this.xsModel.getSubstitutionGroup(ed)) != null) {
                for (int s = 0; s < subs.getLength(); ++s) {
                    XSElementDeclaration sub = (XSElementDeclaration)subs.get(s);
                    this.checkEntry(sub.getNamespace(), sub.getName());
                    this.handleType(sub.getTypeDefinition());
                }
            }
        }

        private void handleType(XSTypeDefinition td) {
            if (td.getTypeCategory() == 15) {
                this.handleComplexType((XSComplexTypeDefinition)td);
            } else {
                this.handleSimpleType((XSSimpleTypeDefinition)td);
            }
        }

        private void handleSimpleType(XSSimpleTypeDefinition std) {
            if (!std.getAnonymous()) {
                this.checkEntry(std.getNamespace(), std.getName());
            }
        }

        private void handleTerm(XSTerm t) {
            switch (t.getType()) {
                case 2: {
                    XSElementDeclaration ed = (XSElementDeclaration)t;
                    this.handleElementDeclaration(ed);
                    break;
                }
                case 7: {
                    XSModelGroup mg = (XSModelGroup)t;
                    XSObjectList particles = mg.getParticles();
                    for (int l = 0; l < particles.getLength(); ++l) {
                        XSParticle part = (XSParticle)particles.get(l);
                        XSTerm tt = part.getTerm();
                        this.handleTerm(tt);
                    }
                    break;
                }
                case 9: {
                    this.handleWildcard((XSWildcard)t);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected term");
                }
            }
        }

        private void handleWildcard(XSWildcard wc) {
            if (wc != null) {
                switch (wc.getConstraintType()) {
                    case 3: {
                        StringList sl = wc.getNsConstraintList();
                        for (int k = 0; k < sl.getLength(); ++k) {
                            String namespace = sl.item(k);
                            this.checkNamespaceUriEntry(namespace);
                        }
                        break;
                    }
                }
            }
        }

        private void handleComplexType(XSComplexTypeDefinition ctd) {
            if (this.cTypes.contains(ctd)) {
                return;
            }
            this.cTypes.add(ctd);
            if (!ctd.getAnonymous()) {
                this.checkEntry(ctd.getNamespace(), ctd.getName());
            }
            XSObjectList attributes = ctd.getAttributeUses();
            for (int i = 0; i < attributes.getLength(); ++i) {
                XSAttributeUse at = (XSAttributeUse)attributes.get(i);
                XSAttributeDeclaration atd = at.getAttrDeclaration();
                this.checkEntry(atd.getNamespace(), atd.getName());
            }
            XSWildcard attributeWC = ctd.getAttributeWildcard();
            this.handleWildcard(attributeWC);
            XSParticle particle = ctd.getParticle();
            if (particle != null) {
                XSTerm t = particle.getTerm();
                this.handleTerm(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamespaceUriEntry
    implements Comparable<NamespaceUriEntry> {
        public final String namespaceUri;
        public final List<String> localNames;

        public NamespaceUriEntry(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            this.localNames = new ArrayList<String>();
        }

        @Override
        public int compareTo(NamespaceUriEntry o) {
            if ("".equals(this.namespaceUri)) {
                return -1;
            }
            if ("".equals(o.namespaceUri)) {
                return 1;
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(this.namespaceUri)) {
                return -1;
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(o.namespaceUri)) {
                return 1;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(this.namespaceUri)) {
                return -1;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(o.namespaceUri)) {
                return 1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(this.namespaceUri)) {
                return -1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(o.namespaceUri)) {
                return 1;
            }
            return this.namespaceUri.compareTo(o.namespaceUri);
        }
    }
}

