/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.exificient.main.api.sax;

import org.opendaylight.netconf.shaded.exificient.core.EXIFactory;
import org.opendaylight.netconf.shaded.exificient.core.FidelityOptions;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.EXIException;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXDecoder;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXEncoder;
import org.opendaylight.netconf.shaded.exificient.main.api.sax.SAXEncoderExtendedHandler;
import org.xml.sax.XMLReader;

public class SAXFactory {
    protected final EXIFactory exiFactory;

    public SAXFactory(EXIFactory exiFactory) {
        this.exiFactory = exiFactory;
    }

    public XMLReader createEXIReader() throws EXIException {
        return new SAXDecoder(this.exiFactory);
    }

    public SAXEncoder createEXIWriter() throws EXIException {
        FidelityOptions fidelityOptions = this.exiFactory.getFidelityOptions();
        if (fidelityOptions.isFidelityEnabled("PRESERVE_PREFIXES") || fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS") || fidelityOptions.isFidelityEnabled("PRESERVE_PIS") || fidelityOptions.isFidelityEnabled("PRESERVE_DTDS")) {
            return new SAXEncoderExtendedHandler(this.exiFactory);
        }
        return new SAXEncoder(this.exiFactory);
    }
}

