/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.agent.local;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgent;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgentFactory;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgentServer;
import org.opendaylight.netconf.shaded.sshd.agent.common.AgentDelegate;
import org.opendaylight.netconf.shaded.sshd.agent.local.AgentImpl;
import org.opendaylight.netconf.shaded.sshd.agent.local.ChannelAgentForwardingFactory;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelFactory;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;

public class LocalAgentFactory
implements SshAgentFactory {
    public static final List<ChannelFactory> DEFAULT_FORWARDING_CHANNELS = Collections.unmodifiableList(Arrays.asList(ChannelAgentForwardingFactory.OPENSSH, ChannelAgentForwardingFactory.IETF));
    private final SshAgent agent;

    public LocalAgentFactory() {
        this.agent = new AgentImpl();
    }

    public LocalAgentFactory(SshAgent agent) {
        this.agent = agent;
    }

    public SshAgent getAgent() {
        return this.agent;
    }

    @Override
    public List<ChannelFactory> getChannelForwardingFactories(FactoryManager manager) {
        return DEFAULT_FORWARDING_CHANNELS;
    }

    @Override
    public SshAgent createClient(Session session, FactoryManager manager) throws IOException {
        return new AgentDelegate(this.agent);
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        return null;
    }
}

