/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.opendaylight.netconf.shaded.sshd.agent.SshAgentFactory;
import org.opendaylight.netconf.shaded.sshd.common.AttributeRepository;
import org.opendaylight.netconf.shaded.sshd.common.AttributeStore;
import org.opendaylight.netconf.shaded.sshd.common.Factory;
import org.opendaylight.netconf.shaded.sshd.common.ServiceFactory;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelFactory;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.channel.RequestHandler;
import org.opendaylight.netconf.shaded.sshd.common.channel.throttle.ChannelStreamWriterResolverManager;
import org.opendaylight.netconf.shaded.sshd.common.file.FileSystemFactory;
import org.opendaylight.netconf.shaded.sshd.common.forward.ForwarderFactory;
import org.opendaylight.netconf.shaded.sshd.common.forward.PortForwardingEventListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceEventListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceFactory;
import org.opendaylight.netconf.shaded.sshd.common.kex.KexFactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.random.Random;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.session.ReservedSessionMessagesManager;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionDisconnectHandlerManager;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionHeartbeatController;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionListenerManager;
import org.opendaylight.netconf.shaded.sshd.common.session.UnknownChannelReferenceHandlerManager;
import org.opendaylight.netconf.shaded.sshd.server.forward.AgentForwardingFilter;
import org.opendaylight.netconf.shaded.sshd.server.forward.ForwardingFilter;
import org.opendaylight.netconf.shaded.sshd.server.forward.TcpForwardingFilter;
import org.opendaylight.netconf.shaded.sshd.server.forward.X11ForwardingFilter;

public interface FactoryManager
extends KexFactoryManager,
SessionListenerManager,
ReservedSessionMessagesManager,
SessionDisconnectHandlerManager,
ChannelListenerManager,
ChannelStreamWriterResolverManager,
UnknownChannelReferenceHandlerManager,
PortForwardingEventListenerManager,
IoServiceEventListenerManager,
AttributeStore,
SessionHeartbeatController {
    public static final String DEFAULT_VERSION = "SSHD-UNKNOWN";

    public String getVersion();

    public IoServiceFactory getIoServiceFactory();

    public Factory<? extends Random> getRandomFactory();

    public List<? extends ChannelFactory> getChannelFactories();

    public SshAgentFactory getAgentFactory();

    public ScheduledExecutorService getScheduledExecutorService();

    public ForwardingFilter getForwardingFilter();

    default public TcpForwardingFilter getTcpForwardingFilter() {
        return this.getForwardingFilter();
    }

    default public AgentForwardingFilter getAgentForwardingFilter() {
        return this.getForwardingFilter();
    }

    default public X11ForwardingFilter getX11ForwardingFilter() {
        return this.getForwardingFilter();
    }

    public ForwarderFactory getForwarderFactory();

    public FileSystemFactory getFileSystemFactory();

    public List<? extends ServiceFactory> getServiceFactories();

    public List<RequestHandler<ConnectionService>> getGlobalRequestHandlers();

    @Override
    default public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
        return FactoryManager.resolveAttribute(this, key);
    }

    public static <T> T resolveAttribute(FactoryManager manager, AttributeRepository.AttributeKey<T> key) {
        Objects.requireNonNull(key, "No key");
        return manager == null ? null : (T)manager.getAttribute(key);
    }
}

