/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.channel;

import java.io.IOException;
import java.util.Map;
import org.opendaylight.netconf.shaded.sshd.common.channel.PtyChannelConfigurationHolder;
import org.opendaylight.netconf.shaded.sshd.common.channel.PtyMode;
import org.opendaylight.netconf.shaded.sshd.common.channel.SttySupport;
import org.opendaylight.netconf.shaded.sshd.common.util.OsUtils;

public interface PtyChannelConfigurationMutator
extends PtyChannelConfigurationHolder {
    public void setPtyType(String var1);

    public void setPtyColumns(int var1);

    public void setPtyLines(int var1);

    public void setPtyWidth(int var1);

    public void setPtyHeight(int var1);

    public void setPtyModes(Map<PtyMode, Integer> var1);

    public static <M extends PtyChannelConfigurationMutator> M copyConfiguration(PtyChannelConfigurationHolder src, M dst) {
        if (src == null || dst == null) {
            return dst;
        }
        dst.setPtyColumns(src.getPtyColumns());
        dst.setPtyHeight(src.getPtyHeight());
        dst.setPtyLines(src.getPtyLines());
        dst.setPtyModes(src.getPtyModes());
        dst.setPtyType(src.getPtyType());
        dst.setPtyWidth(src.getPtyWidth());
        return dst;
    }

    public static <M extends PtyChannelConfigurationMutator> M setupSensitiveDefaultPtyConfiguration(M mutator) throws IOException, InterruptedException {
        if (mutator == null) {
            return null;
        }
        if (OsUtils.isUNIX()) {
            mutator.setPtyModes(SttySupport.getUnixPtyModes());
            mutator.setPtyColumns(SttySupport.getTerminalWidth());
            mutator.setPtyLines(SttySupport.getTerminalHeight());
        } else {
            mutator.setPtyType("windows");
        }
        return mutator;
    }
}

