/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.channel;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.MapEntryUtils;

public enum PtyMode {
    VINTR(1),
    VQUIT(2),
    VERASE(3),
    VKILL(4),
    VEOF(5),
    VEOL(6),
    VEOL2(7),
    VSTART(8),
    VSTOP(9),
    VSUSP(10),
    VDSUSP(11),
    VREPRINT(12),
    VWERASE(13),
    VLNEXT(14),
    VFLUSH(15),
    VSWTCH(16),
    VSTATUS(17),
    VDISCARD(18),
    IGNPAR(30),
    PARMRK(31),
    INPCK(32),
    ISTRIP(33),
    INLCR(34),
    IGNCR(35),
    ICRNL(36),
    IUCLC(37),
    IXON(38),
    IXANY(39),
    IXOFF(40),
    IMAXBEL(41),
    IUTF8(42),
    ISIG(50),
    ICANON(51),
    XCASE(52),
    ECHO(53),
    ECHOE(54),
    ECHOK(55),
    ECHONL(56),
    NOFLSH(57),
    TOSTOP(58),
    IEXTEN(59),
    ECHOCTL(60),
    ECHOKE(61),
    PENDIN(62),
    OPOST(70),
    OLCUC(71),
    ONLCR(72),
    OCRNL(73),
    ONOCR(74),
    ONLRET(75),
    CS7(90),
    CS8(91),
    PARENB(92),
    PARODD(93),
    TTY_OP_ISPEED(128),
    TTY_OP_OSPEED(129);

    public static final byte TTY_OP_END = 0;
    public static final Integer FALSE_SETTING;
    public static final Integer TRUE_SETTING;
    public static final Set<PtyMode> MODES;
    public static final NavigableMap<Integer, PtyMode> COMMANDS;
    public static final ToIntFunction<PtyMode> OPCODE_EXTRACTOR;
    public static final Comparator<PtyMode> BY_OPCODE;
    private final int v;

    private PtyMode(int v) {
        this.v = v;
    }

    public int toInt() {
        return this.v;
    }

    public static PtyMode fromInt(int b) {
        return (PtyMode)((Object)COMMANDS.get(0xFF & b));
    }

    public static PtyMode fromName(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        for (PtyMode m : MODES) {
            if (!name.equalsIgnoreCase(m.name())) continue;
            return m;
        }
        return null;
    }

    public static Map<PtyMode, Integer> createEnabledOptions(PtyMode ... options) {
        return PtyMode.createEnabledOptions(GenericUtils.of((Enum[])options));
    }

    public static Map<PtyMode, Integer> createEnabledOptions(Collection<PtyMode> options) {
        if (GenericUtils.isEmpty(options)) {
            return Collections.emptyMap();
        }
        EnumMap<PtyMode, Integer> modes = new EnumMap<PtyMode, Integer>(PtyMode.class);
        for (PtyMode m : options) {
            modes.put(m, TRUE_SETTING);
        }
        return modes;
    }

    public static Set<PtyMode> resolveEnabledOptions(Map<PtyMode, ?> modes, PtyMode ... options) {
        return PtyMode.resolveEnabledOptions(modes, GenericUtils.of((Enum[])options));
    }

    public static Set<PtyMode> resolveEnabledOptions(Map<PtyMode, ?> modes, Collection<PtyMode> options) {
        if (MapEntryUtils.isEmpty(modes) || GenericUtils.isEmpty(options)) {
            return Collections.emptySet();
        }
        EnumSet<PtyMode> enabled = EnumSet.noneOf(PtyMode.class);
        for (PtyMode m : options) {
            if (!PtyMode.getBooleanSettingValue(modes, m)) continue;
            enabled.add(m);
        }
        return enabled;
    }

    public static boolean getBooleanSettingValue(Map<PtyMode, ?> modes, PtyMode m) {
        if (m == null || MapEntryUtils.isEmpty(modes)) {
            return false;
        }
        return PtyMode.getBooleanSettingValue(modes.get((Object)m));
    }

    public static boolean getBooleanSettingValue(Map<PtyMode, ?> modes, Collection<PtyMode> enablers, boolean defaultValue) {
        if (MapEntryUtils.isEmpty(modes) || GenericUtils.isEmpty(enablers)) {
            return defaultValue;
        }
        int settingsCount = 0;
        for (PtyMode m : enablers) {
            Object v = modes.get((Object)m);
            if (v == null) continue;
            ++settingsCount;
            if (!PtyMode.getBooleanSettingValue(v)) continue;
            return true;
        }
        if (settingsCount > 0) {
            return false;
        }
        return defaultValue;
    }

    public static boolean getBooleanSettingValue(Object v) {
        return v instanceof Number && PtyMode.getBooleanSettingValue(((Number)v).intValue());
    }

    public static boolean getBooleanSettingValue(int v) {
        return v != 0;
    }

    public static boolean isCharSetting(PtyMode m) {
        if (m == null) {
            return false;
        }
        String name = m.name();
        char ch = name.charAt(0);
        return ch == 'v' || ch == 'V';
    }

    static {
        FALSE_SETTING = 0;
        TRUE_SETTING = 1;
        MODES = Collections.unmodifiableSet(EnumSet.allOf(PtyMode.class));
        COMMANDS = Collections.unmodifiableNavigableMap(MapEntryUtils.toSortedMap(MODES, PtyMode::toInt, Function.identity(), Comparator.naturalOrder()));
        OPCODE_EXTRACTOR = op -> op == null ? -1 : op.toInt();
        BY_OPCODE = (o1, o2) -> {
            int v1 = OPCODE_EXTRACTOR.applyAsInt((PtyMode)((Object)o1));
            int v2 = OPCODE_EXTRACTOR.applyAsInt((PtyMode)((Object)o2));
            return Integer.compare(v1, v2);
        };
    }
}

