/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.opendaylight.netconf.shaded.sshd.common.compression.BuiltinCompressions;
import org.opendaylight.netconf.shaded.sshd.common.compression.Compression;
import org.opendaylight.netconf.shaded.sshd.common.compression.CompressionFactory;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;

public enum CompressionConfigValue implements CompressionFactory
{
    YES(BuiltinCompressions.zlib),
    NO(BuiltinCompressions.none),
    DELAYED(BuiltinCompressions.delayedZlib);

    public static final Set<CompressionConfigValue> VALUES;
    private final CompressionFactory factory;

    private CompressionConfigValue(CompressionFactory delegate) {
        this.factory = delegate;
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    @Override
    public final Compression create() {
        return (Compression)this.factory.create();
    }

    @Override
    public boolean isSupported() {
        return this.factory.isSupported();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isDelayed() {
        return this.factory.isDelayed();
    }

    @Override
    public boolean isCompressionExecuted() {
        return this.factory.isCompressionExecuted();
    }

    public static CompressionConfigValue fromName(String n) {
        if (GenericUtils.isEmpty(n)) {
            return null;
        }
        for (CompressionConfigValue v : VALUES) {
            if (!n.equalsIgnoreCase(v.name())) continue;
            return v;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(CompressionConfigValue.class));
    }
}

