/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config.keys.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.PrivateKeyObfuscator;
import org.opendaylight.netconf.shaded.sshd.common.random.JceRandom;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.BufferUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;

public abstract class AbstractPrivateKeyObfuscator
implements PrivateKeyObfuscator {
    private final String algName;

    protected AbstractPrivateKeyObfuscator(String name) {
        this.algName = ValidateUtils.checkNotNullAndNotEmpty(name, "No name specified");
    }

    @Override
    public final String getCipherName() {
        return this.algName;
    }

    @Override
    public byte[] generateInitializationVector(PrivateKeyEncryptionContext encContext) throws GeneralSecurityException {
        int ivSize = this.resolveInitializationVectorLength(encContext);
        byte[] initVector = new byte[ivSize];
        SecureRandom randomizer = JceRandom.getGlobalInstance();
        ((Random)randomizer).nextBytes(initVector);
        return initVector;
    }

    @Override
    public <A extends Appendable> A appendPrivateKeyEncryptionContext(A sb, PrivateKeyEncryptionContext encContext) throws IOException {
        if (encContext == null) {
            return sb;
        }
        sb.append("DEK-Info: ").append(encContext.getCipherName()).append('-').append(encContext.getCipherType()).append('-').append(encContext.getCipherMode());
        byte[] initVector = encContext.getInitVector();
        Objects.requireNonNull(initVector, "No encryption init vector");
        ValidateUtils.checkTrue(initVector.length > 0, "Empty encryption init vector");
        BufferUtils.appendHex(sb.append(','), '\u0000', initVector);
        sb.append(System.lineSeparator());
        return sb;
    }

    protected abstract int resolveInitializationVectorLength(PrivateKeyEncryptionContext var1) throws GeneralSecurityException;

    protected abstract int resolveKeyLength(PrivateKeyEncryptionContext var1) throws GeneralSecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] deriveEncryptionKey(PrivateKeyEncryptionContext encContext, int outputKeyLength) throws IOException, GeneralSecurityException {
        Objects.requireNonNull(encContext, "No encryption context");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherName(), "No cipher name");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherType(), "No cipher type");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherMode(), "No cipher mode");
        byte[] initVector = Objects.requireNonNull(encContext.getInitVector(), "No encryption init vector");
        ValidateUtils.checkTrue(initVector.length > 0, "Empty encryption init vector");
        String password = ValidateUtils.checkNotNullAndNotEmpty(encContext.getPassword(), "No encryption password");
        byte[] passBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] prevHash = GenericUtils.EMPTY_BYTE_ARRAY;
        try {
            byte[] keyValue = new byte[outputKeyLength];
            MessageDigest hash = SecurityUtils.getMessageDigest("md5");
            int index = 0;
            int remLen = keyValue.length;
            while (index < keyValue.length) {
                hash.reset();
                hash.update(prevHash, 0, prevHash.length);
                hash.update(passBytes, 0, passBytes.length);
                hash.update(initVector, 0, Math.min(initVector.length, 8));
                prevHash = hash.digest();
                System.arraycopy(prevHash, 0, keyValue, index, Math.min(remLen, prevHash.length));
                index += prevHash.length;
                remLen -= prevHash.length;
            }
            byte[] byArray = keyValue;
            return byArray;
        }
        finally {
            password = null;
            Arrays.fill(passBytes, (byte)0);
            Arrays.fill(prevHash, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] applyPrivateKeyCipher(byte[] bytes, PrivateKeyEncryptionContext encContext, int numBits, byte[] keyValue, boolean encryptIt) throws IOException, GeneralSecurityException {
        Objects.requireNonNull(encContext, "No encryption context");
        String cipherName = ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherName(), "No cipher name");
        ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherType(), "No cipher type");
        String cipherMode = ValidateUtils.checkNotNullAndNotEmpty(encContext.getCipherMode(), "No cipher mode");
        Objects.requireNonNull(bytes, "No source data");
        Objects.requireNonNull(keyValue, "No encryption key");
        ValidateUtils.checkTrue(keyValue.length > 0, "Empty encryption key");
        byte[] initVector = Objects.requireNonNull(encContext.getInitVector(), "No encryption init vector");
        ValidateUtils.checkTrue(initVector.length > 0, "Empty encryption init vector");
        String xform = cipherName + "/" + cipherMode + "/NoPadding";
        int maxAllowedBits = Cipher.getMaxAllowedKeyLength(xform);
        if (numBits > maxAllowedBits) {
            throw new InvalidKeySpecException("applyPrivateKeyCipher(" + xform + ")[encrypt=" + encryptIt + "] required key length (" + numBits + ") exceeds max. available: " + maxAllowedBits);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(keyValue, cipherName);
        IvParameterSpec ivspec = new IvParameterSpec(initVector);
        Cipher cipher = SecurityUtils.getCipher(xform);
        int blockSize = cipher.getBlockSize();
        int dataSize = bytes.length;
        cipher.init(encryptIt ? 1 : 2, (Key)skeySpec, ivspec);
        if (blockSize <= 0) {
            return cipher.doFinal(bytes);
        }
        int remLen = dataSize % blockSize;
        if (remLen <= 0) {
            return cipher.doFinal(bytes);
        }
        int updateSize = dataSize - remLen;
        byte[] lastBlock = new byte[blockSize];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(dataSize);
        try {
            Arrays.fill(lastBlock, (byte)10);
            System.arraycopy(bytes, updateSize, lastBlock, 0, remLen);
            try {
                byte[] buf = cipher.update(bytes, 0, updateSize);
                try {
                    baos.write(buf);
                }
                finally {
                    Arrays.fill(buf, (byte)0);
                }
                buf = cipher.doFinal(lastBlock);
                try {
                    baos.write(buf);
                }
                finally {
                    Arrays.fill(buf, (byte)0);
                }
            }
            finally {
                baos.close();
            }
        }
        finally {
            Arrays.fill(lastBlock, (byte)0);
        }
        return baos.toByteArray();
    }
}

